/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.processor;

import java.sql.Timestamp;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.TxOrcsData;
import org.eclipse.osee.orcs.db.internal.loader.data.TransactionObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.processor.LoadProcessor;

public class TransactionLoadProcessor
extends LoadProcessor<TxOrcsData, TransactionObjectFactory> {
    public TransactionLoadProcessor(TransactionObjectFactory factory) {
        super(factory);
    }

    @Override
    protected TxOrcsData createData(Object conditions, TransactionObjectFactory factory, JdbcStatement chStmt, Options options) throws OseeCoreException {
        BranchId branch = BranchId.create((long)chStmt.getLong("branch_id"), (ArtifactId)OptionsUtil.getFromBranchView((Options)options));
        Long localId = chStmt.getLong("transaction_id");
        Long buildId = chStmt.getLong("build_id");
        TransactionDetailsType type = TransactionDetailsType.toEnum((int)chStmt.getInt("tx_type"));
        String comment = chStmt.getString("osee_comment");
        Timestamp date = chStmt.getTimestamp("time");
        ArtifactId authorId = ArtifactId.valueOf((long)chStmt.getLong("author"));
        ArtifactId commitId = ArtifactId.valueOf((long)chStmt.getLong("commit_art_id"));
        return factory.createTxData(localId, type, date, comment, branch, authorId, commitId, buildId);
    }
}

