/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.processor;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.db.internal.loader.data.RelationObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.processor.LoadProcessor;

public class RelationLoadProcessor
extends LoadProcessor<RelationData, RelationObjectFactory> {
    private final Log logger;

    public RelationLoadProcessor(Log logger, RelationObjectFactory factory) {
        super(factory);
        this.logger = logger;
    }

    @Override
    protected RelationData createData(Object conditions, RelationObjectFactory factory, JdbcStatement chStmt, Options options) throws OseeCoreException {
        RelationData toReturn = null;
        BranchId branch = BranchId.create((long)chStmt.getLong("branch_id"), (ArtifactId)OptionsUtil.getFromBranchView((Options)options));
        int aArtId = chStmt.getInt("a_art_id");
        int bArtId = chStmt.getInt("b_art_id");
        long typeId = chStmt.getLong("rel_link_type_id");
        long gammaId = chStmt.getInt("gamma_id");
        ApplicabilityId applicId = ApplicabilityId.valueOf((long)chStmt.getLong("app_id"));
        boolean historical = OptionsUtil.isHistorical((Options)options);
        CreateConditions condition = this.asConditions(conditions);
        if (!condition.isSame(branch, aArtId, bArtId, typeId)) {
            condition.saveConditions(branch, aArtId, bArtId, typeId, gammaId);
            TransactionId txId = TransactionId.valueOf((long)chStmt.getLong("transaction_id"));
            VersionData version = factory.createVersion(branch, txId, gammaId, historical);
            if (historical) {
                version.setStripeId(TransactionId.valueOf((long)chStmt.getLong("stripe_transaction_id")));
            }
            int localId = chStmt.getInt("rel_link_id");
            ModificationType modType = ModificationType.getMod((int)chStmt.getInt("mod_type"));
            String rationale = chStmt.getString("rationale");
            if (rationale == null) {
                rationale = "";
            }
            toReturn = factory.createRelationData(version, (Integer)localId, typeId, modType, aArtId, bArtId, rationale, applicId);
        } else if (!historical) {
            this.logger.warn("multiple relation versions for branch[%s] rel_type [%d] a_artId[%d] b_artId[%s] previousGammaId[%s] currentGammaId[%s]", new Object[]{branch, typeId, aArtId, bArtId, condition.previousGammaId, gammaId});
        }
        return toReturn;
    }

    @Override
    protected Object createPreConditions(Options options) {
        return new CreateConditions();
    }

    private CreateConditions asConditions(Object conditions) {
        return (CreateConditions)conditions;
    }

    private static final class CreateConditions {
        BranchId previousBranchId = BranchId.SENTINEL;
        int previousArtIdA = -1;
        int previousArtIdB = -1;
        long previousTypeId = -1L;
        long previousGammaId = -1L;

        private CreateConditions() {
        }

        boolean isSame(BranchId branch, int aArtId, int bArtId, long typeId) {
            return this.previousBranchId.equals(branch) && this.previousArtIdA == aArtId && this.previousArtIdB == bArtId && this.previousTypeId == typeId;
        }

        void saveConditions(BranchId branch, int aArtId, int bArtId, long typeId, long gammaId) {
            this.previousBranchId = branch;
            this.previousArtIdA = aArtId;
            this.previousArtIdB = bArtId;
            this.previousTypeId = typeId;
            this.previousGammaId = gammaId;
        }
    }
}

