/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.processor;

import java.sql.Timestamp;
import java.util.Collection;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.DynamicData;
import org.eclipse.osee.orcs.core.ds.DynamicDataHandler;
import org.eclipse.osee.orcs.core.ds.DynamicObject;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.db.internal.loader.ProxyDataFactory;
import org.eclipse.osee.orcs.db.internal.loader.processor.AbstractLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.DynamicObjectBuilder;
import org.eclipse.osee.orcs.db.internal.sql.ObjectField;
import org.eclipse.osee.orcs.db.internal.sql.SqlFieldResolver;

public class DynamicLoadProcessor
extends AbstractLoadProcessor<DynamicDataHandler> {
    private final Log logger;
    private final OrcsTypes orcsTypes;
    private final ProxyDataFactory proxyFactory;

    public DynamicLoadProcessor(Log logger, OrcsTypes orcsTypes, ProxyDataFactory proxyFactory) {
        this.logger = logger;
        this.orcsTypes = orcsTypes;
        this.proxyFactory = proxyFactory;
    }

    @Override
    protected Object createPreConditions(Options options) {
        return new DynamicObjectBuilder(this.logger, this.orcsTypes, options);
    }

    private DynamicObjectBuilder getBuilder(DynamicDataHandler handler, Object conditions) {
        DynamicObjectBuilder builder = (DynamicObjectBuilder)conditions;
        builder.setHandler(handler);
        return builder;
    }

    @Override
    protected void onRow(DynamicDataHandler handler, JdbcStatement chStmt, Options options, Object conditions) {
        DynamicObjectBuilder builder = this.getBuilder(handler, conditions);
        for (DynamicData dynamicData : builder.getDescriptors()) {
            this.processData(chStmt, builder, dynamicData);
        }
    }

    @Override
    protected void onEnd(DynamicDataHandler handler, Options options, Object conditions, int rowCount) {
        if (rowCount > 0) {
            this.getBuilder(handler, conditions).onEnd();
        }
    }

    private void processData(JdbcStatement chStmt, DynamicObjectBuilder builder, DynamicData data) {
        if (data instanceof DynamicObject) {
            DynamicObject dynamicObject = (DynamicObject)data;
            builder.onDynamicObjectStart(dynamicObject);
            for (DynamicData child : dynamicObject.getChildren()) {
                this.processData(chStmt, builder, child);
            }
            builder.onDynamicObjectEnd(dynamicObject);
        } else {
            ObjectField field = SqlFieldResolver.getObjectField(data);
            if (field.isComposite()) {
                this.processCompositeField(chStmt, builder, data);
            } else {
                String uniqueId = SqlFieldResolver.getColumnUniqueId(data);
                Object value = this.getValue(chStmt, field, uniqueId);
                builder.onDynamicField(data, data.getName(), value);
            }
        }
    }

    private Object getValue(JdbcStatement chStmt, ObjectField field, String columnName) {
        Object object = null;
        switch (field) {
            case branch_type: {
                object = this.getBranchType(chStmt, columnName);
                break;
            }
            case branch_state: {
                object = this.getBranchState(chStmt, columnName);
                break;
            }
            case branch_archive_state: {
                object = this.getBranchArchivedState(chStmt, columnName);
                break;
            }
            case tx_type: {
                object = this.getTxType(chStmt, columnName);
                break;
            }
            case tx_current: {
                object = this.getTxCurrent(chStmt, columnName);
                break;
            }
            case art_mod_type: 
            case attr_mod_type: 
            case rel_mod_type: {
                object = this.getModType(chStmt, columnName);
                break;
            }
            default: {
                object = this.getObjectByType(chStmt, field, columnName);
            }
        }
        return object;
    }

    private Object getObjectByType(JdbcStatement chStmt, ObjectField field, String columnName) {
        Class clazz = field.getSQLType().getJavaEquivalentClass();
        Object object = clazz.equals(Boolean.class) ? Boolean.valueOf(chStmt.getBoolean(columnName)) : (clazz.equals(Integer.class) ? Integer.valueOf(chStmt.getInt(columnName)) : (clazz.equals(Long.class) ? Long.valueOf(chStmt.getLong(columnName)) : (clazz.equals(Double.class) ? Double.valueOf(chStmt.getDouble(columnName)) : (clazz.equals(Timestamp.class) ? chStmt.getTimestamp(columnName) : (clazz.equals(String.class) ? chStmt.getString(columnName) : chStmt.getObject(columnName))))));
        return object;
    }

    private void processCompositeField(JdbcStatement chStmt, DynamicObjectBuilder builder, DynamicData data) {
        Collection<String> columnIds = SqlFieldResolver.getColumnUniqueIds(data);
        DataProxy value = this.getProxyData(chStmt, columnIds);
        builder.onDynamicField(data, data.getName(), value);
    }

    private DataProxy getProxyData(JdbcStatement chStmt, Collection<String> columnIds) {
        String typeColumnName = null;
        String uriColumnName = null;
        String valueColumnName = null;
        for (String id : columnIds) {
            if (id.contains("uri")) {
                uriColumnName = id;
                continue;
            }
            if (id.contains("type")) {
                typeColumnName = id;
                continue;
            }
            if (!id.contains("value")) continue;
            valueColumnName = id;
        }
        long typeUuid = chStmt.getLong(typeColumnName);
        String value = chStmt.getString(valueColumnName);
        String uri = chStmt.getString(uriColumnName);
        return this.proxyFactory.createProxy(typeUuid, (Object)value, uri);
    }

    private BranchType getBranchType(JdbcStatement chStmt, String columnName) {
        return BranchType.valueOf((int)chStmt.getInt(columnName));
    }

    private BranchState getBranchState(JdbcStatement chStmt, String columnName) {
        return BranchState.getBranchState((int)chStmt.getInt(columnName));
    }

    private BranchArchivedState getBranchArchivedState(JdbcStatement chStmt, String columnName) {
        return BranchArchivedState.valueOf((int)chStmt.getInt(columnName));
    }

    private TransactionDetailsType getTxType(JdbcStatement chStmt, String columnName) {
        return TransactionDetailsType.toEnum((int)chStmt.getInt(columnName));
    }

    private ModificationType getModType(JdbcStatement chStmt, String columnName) {
        return ModificationType.getMod((int)chStmt.getInt(columnName));
    }

    private TxChange getTxCurrent(JdbcStatement chStmt, String columnName) {
        return TxChange.getChangeType((int)chStmt.getInt(columnName));
    }
}

