/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.processor;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.core.ds.BranchData;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.db.internal.loader.data.BranchObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.processor.LoadProcessor;

public class BranchLoadProcessor
extends LoadProcessor<BranchData, BranchObjectFactory> {
    public BranchLoadProcessor(BranchObjectFactory factory) {
        super(factory);
    }

    @Override
    protected BranchData createData(Object conditions, BranchObjectFactory factory, JdbcStatement chStmt, Options options) throws OseeCoreException {
        BranchId branch = BranchId.create((long)chStmt.getLong("branch_id"), (ArtifactId)OptionsUtil.getFromBranchView((Options)options));
        String branchName = chStmt.getString("branch_name");
        BranchState branchState = BranchState.getBranchState((int)chStmt.getInt("branch_state"));
        BranchType branchType = BranchType.valueOf((int)chStmt.getInt("branch_type"));
        BranchArchivedState archiveState = BranchArchivedState.valueOf((int)chStmt.getInt("archived"));
        BranchId parentBranchId = BranchId.valueOf((long)chStmt.getLong("parent_branch_id"));
        TransactionId sourceTx = TransactionId.valueOf((long)chStmt.getLong("parent_transaction_id"));
        TransactionId baseTx = TransactionId.valueOf((long)chStmt.getLong("baseline_transaction_id"));
        ArtifactId assocArtId = ArtifactId.valueOf((long)chStmt.getLong("associated_art_id"));
        boolean inheritAccessControl = chStmt.getInt("inherit_access_control") != 0;
        return factory.createBranchData(branch, branchType, branchName, parentBranchId, baseTx, sourceTx, archiveState, branchState, assocArtId, inheritAccessControl);
    }
}

