/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.processor;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.loader.data.AttributeObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.processor.LoadProcessor;

public class AttributeLoadProcessor
extends LoadProcessor<AttributeData, AttributeObjectFactory> {
    private final Log logger;
    private final AttributeTypes attributeTypes;

    public AttributeLoadProcessor(Log logger, AttributeObjectFactory factory, AttributeTypes attributeTypes) {
        super(factory);
        this.logger = logger;
        this.attributeTypes = attributeTypes;
    }

    @Override
    protected AttributeData createData(Object conditions, AttributeObjectFactory factory, JdbcStatement chStmt, Options options) throws OseeCoreException {
        AttributeData toReturn = null;
        BranchId branch = BranchId.create((long)chStmt.getLong("branch_id"), (ArtifactId)OptionsUtil.getFromBranchView((Options)options));
        int artId = chStmt.getInt("id2");
        int attrId = chStmt.getInt("attr_id");
        long gammaId = chStmt.getInt("gamma_id");
        ModificationType modType = ModificationType.getMod((int)chStmt.getInt("mod_type"));
        ApplicabilityId applicId = ApplicabilityId.valueOf((long)chStmt.getLong("app_id"));
        boolean historical = OptionsUtil.isHistorical((Options)options);
        CreateConditions condition = this.asConditions(conditions);
        if (!condition.isSame(branch, artId, attrId)) {
            condition.saveConditions(branch, artId, attrId, gammaId, modType);
            TransactionId txId = TransactionId.valueOf((long)chStmt.getLong("transaction_id"));
            VersionData version = factory.createVersion(branch, txId, gammaId, historical);
            if (historical) {
                version.setStripeId(TransactionId.valueOf((long)chStmt.getLong("stripe_transaction_id")));
            }
            AttributeTypeId attributeType = AttributeTypeId.valueOf((Long)chStmt.getLong("attr_type_id"));
            String baseAttributeType = this.attributeTypes.getBaseAttributeTypeId(attributeType);
            Object value = null;
            if (baseAttributeType.contains("BooleanAttribute")) {
                value = chStmt.getBoolean("value");
            } else if (baseAttributeType.contains("FloatingPointAttribute")) {
                value = chStmt.getDouble("value");
            } else if (baseAttributeType.contains("IntegerAttribute")) {
                value = chStmt.getInt("value");
            } else if (baseAttributeType.contains("LongAttribute")) {
                value = chStmt.getLong("value");
            } else if (baseAttributeType.contains("DateAttribute")) {
                value = chStmt.getLong("value");
            } else {
                value = chStmt.getString("value");
                if (baseAttributeType.contains("EnumeratedAttribute")) {
                    value = Strings.intern((String)((String)value));
                }
            }
            String uri = chStmt.getString("uri");
            toReturn = factory.createAttributeData(version, attrId, attributeType, modType, artId, value, uri, applicId);
        } else if (!historical) {
            this.logger.warn("multiple attribute versions for attribute id [%s] artifact id[%s] branch[%s] previousGammaId[%s] currentGammaId[%s] previousModType[%s] currentModType[%s]", new Object[]{attrId, artId, branch, condition.previousGammaId, gammaId, condition.previousModType, modType});
        }
        return toReturn;
    }

    @Override
    protected Object createPreConditions(Options options) {
        return new CreateConditions();
    }

    private CreateConditions asConditions(Object conditions) {
        return (CreateConditions)conditions;
    }

    private static final class CreateConditions {
        int previousArtId = -1;
        BranchId previousBranchId = BranchId.SENTINEL;
        int previousAttrId = -1;
        long previousGammaId = -1L;
        ModificationType previousModType = null;

        private CreateConditions() {
        }

        boolean isSame(BranchId branch, int artifactId, int attrId) {
            return this.previousBranchId.equals(branch) && this.previousArtId == artifactId && this.previousAttrId == attrId;
        }

        void saveConditions(BranchId branch, int artifactId, int attrId, long gammaId, ModificationType modType) {
            this.previousBranchId = branch;
            this.previousArtId = artifactId;
            this.previousAttrId = attrId;
            this.previousGammaId = gammaId;
            this.previousModType = modType;
        }
    }
}

