/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.processor;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.db.internal.loader.data.ArtifactObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.processor.LoadProcessor;

public class ArtifactLoadProcessor
extends LoadProcessor<ArtifactData, ArtifactObjectFactory> {
    public ArtifactLoadProcessor(ArtifactObjectFactory factory) {
        super(factory);
    }

    @Override
    protected ArtifactData createData(Object conditions, ArtifactObjectFactory factory, JdbcStatement chStmt, Options options) throws OseeCoreException {
        ArtifactData toReturn = null;
        int artifactId = chStmt.getInt("id2");
        BranchId branch = BranchId.create((long)chStmt.getLong("branch_id"), (ArtifactId)OptionsUtil.getFromBranchView((Options)options));
        CreateConditions onCreate = this.asConditions(conditions);
        if (!onCreate.isSame(branch, artifactId)) {
            ModificationType modType = ModificationType.getMod((int)chStmt.getInt("mod_type"));
            ApplicabilityId applicId = ApplicabilityId.valueOf((long)chStmt.getLong("app_id"));
            boolean historical = OptionsUtil.isHistorical((Options)options);
            if (!historical || OptionsUtil.areDeletedArtifactsIncluded((Options)options) || modType != ModificationType.DELETED) {
                long gamma = chStmt.getInt("gamma_id");
                TransactionId txId = TransactionId.valueOf((long)chStmt.getLong("transaction_id"));
                VersionData version = factory.createVersion(branch, txId, gamma, historical);
                if (historical) {
                    version.setStripeId(TransactionId.valueOf((long)chStmt.getLong("stripe_transaction_id")));
                }
                long typeId = chStmt.getLong("art_type_id");
                String guid = chStmt.getString("guid");
                toReturn = factory.createArtifactData(version, (Integer)artifactId, typeId, modType, guid, applicId);
            }
            onCreate.saveConditions(branch, artifactId);
        }
        return toReturn;
    }

    @Override
    protected Object createPreConditions(Options options) {
        return new CreateConditions();
    }

    private CreateConditions asConditions(Object conditions) {
        return (CreateConditions)conditions;
    }

    private static final class CreateConditions {
        int previousArtId = -1;
        BranchId previousBranchId = BranchId.SENTINEL;

        private CreateConditions() {
        }

        boolean isSame(BranchId branch, int artifactId) {
            return this.previousBranchId.equals(branch) && this.previousArtId == artifactId;
        }

        void saveConditions(BranchId branch, int artifactId) {
            this.previousBranchId = branch;
            this.previousArtId = artifactId;
        }
    }
}

