/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.handlers;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaRelation;
import org.eclipse.osee.orcs.db.internal.loader.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class RelationSqlHandler
extends SqlHandler<CriteriaRelation> {
    private CriteriaRelation criteria;
    private String jIdAlias;
    private String jTypeIdAlias;
    private String jArtAlias;
    private String relationAlias;
    private String txsAlias;
    private Collection<Long> typeIds;
    private AbstractJoinQuery joinIdQuery;
    private AbstractJoinQuery joinTypeQuery;

    @Override
    public int getPriority() {
        return SqlHandlerPriority.RELATION_LOADER.ordinal();
    }

    @Override
    public void setData(CriteriaRelation criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addSelect(AbstractSqlWriter writer) throws OseeCoreException {
        writer.write("%s.rel_link_id, %s.rel_link_type_id, %s.a_art_id, %s.b_art_id, %s.rationale", this.relationAlias, this.relationAlias, this.relationAlias, this.relationAlias, this.relationAlias);
    }

    @Override
    public void addTables(AbstractSqlWriter writer) throws OseeCoreException {
        this.jArtAlias = writer.addTable(TableEnum.JOIN_ID4_TABLE);
        if (this.criteria.getIds().size() > 1) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.typeIds = this.getLocalTypeIds();
        if (this.typeIds.size() > 1) {
            this.jTypeIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.relationAlias = writer.addTable(TableEnum.RELATION_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE);
    }

    private Collection<Long> getLocalTypeIds() throws OseeCoreException {
        HashSet<Long> toReturn = new HashSet<Long>();
        for (Id id : this.criteria.getTypes()) {
            toReturn.add(id.getId());
        }
        return toReturn;
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        writer.write("(%s.a_art_id = %s.id2 OR %s.b_art_id = %s.id2)", this.relationAlias, this.jArtAlias, this.relationAlias, this.jArtAlias);
        writer.write(" AND ", new Object[0]);
        writer.write(this.jArtAlias, new Object[0]);
        writer.write(".query_id = ?", new Object[0]);
        writer.addParameter(this.criteria.getQueryId());
        Collection<Integer> ids = this.criteria.getIds();
        if (!ids.isEmpty()) {
            writer.write(" AND ", new Object[0]);
            if (ids.size() > 1) {
                this.joinIdQuery = writer.writeIdJoin(ids);
                writer.write(this.relationAlias, new Object[0]);
                writer.write(".rel_link_id = ", new Object[0]);
                writer.write(this.jIdAlias, new Object[0]);
                writer.write(".id AND ", new Object[0]);
                writer.write(this.jIdAlias, new Object[0]);
                writer.write(".query_id = ?", new Object[0]);
                writer.addParameter(this.joinIdQuery.getQueryId());
            } else {
                writer.write(this.relationAlias, new Object[0]);
                writer.write(".rel_link_id = ?", new Object[0]);
                writer.addParameter(ids.iterator().next());
            }
        }
        if (!this.typeIds.isEmpty()) {
            writer.write(" AND ", new Object[0]);
            if (this.typeIds.size() > 1) {
                this.joinTypeQuery = writer.writeIdJoin(this.typeIds);
                writer.write(this.relationAlias, new Object[0]);
                writer.write(".rel_link_type_id = ", new Object[0]);
                writer.write(this.jTypeIdAlias, new Object[0]);
                writer.write(".id AND ", new Object[0]);
                writer.write(this.jTypeIdAlias, new Object[0]);
                writer.write(".query_id = ?", new Object[0]);
                writer.addParameter(this.joinTypeQuery.getQueryId());
            } else {
                writer.write(this.relationAlias, new Object[0]);
                writer.write(".rel_link_type_id = ?", new Object[0]);
                writer.addParameter(this.typeIds.iterator().next());
            }
        }
        writer.write(" AND ", new Object[0]);
        writer.write(this.relationAlias, new Object[0]);
        writer.write(".gamma_id = ", new Object[0]);
        writer.write(this.txsAlias, new Object[0]);
        writer.write(".gamma_id", new Object[0]);
        writer.write("\n AND ", new Object[0]);
        writer.write(writer.getTxBranchFilter(this.txsAlias), new Object[0]);
        return true;
    }
}

