/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.handlers;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaAttribute;
import org.eclipse.osee.orcs.db.internal.loader.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class AttributeSqlHandler
extends SqlHandler<CriteriaAttribute> {
    private CriteriaAttribute criteria;
    private String jIdAlias;
    private String jTypeIdAlias;
    private String jArtAlias;
    private String attrAlias;
    private String txsAlias;
    private AbstractJoinQuery joinIdQuery;
    private AbstractJoinQuery joinTypeQuery;

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_LOADER.ordinal();
    }

    @Override
    public void setData(CriteriaAttribute criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addSelect(AbstractSqlWriter writer) throws OseeCoreException {
        writer.write("%s.attr_id, %s.attr_type_id, %s.value, %s.uri", this.attrAlias, this.attrAlias, this.attrAlias, this.attrAlias);
    }

    @Override
    public void addTables(AbstractSqlWriter writer) throws OseeCoreException {
        this.jArtAlias = writer.addTable(TableEnum.JOIN_ID4_TABLE);
        if (this.criteria.getIds().size() > 1) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        if (this.criteria.getTypes().size() > 1) {
            this.jTypeIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.attrAlias = writer.addTable(TableEnum.ATTRIBUTE_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE);
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        Collection<? extends AttributeTypeId> types;
        writer.write(this.attrAlias, new Object[0]);
        writer.write(".art_id = ", new Object[0]);
        writer.write(this.jArtAlias, new Object[0]);
        writer.write(".id2 AND ", new Object[0]);
        writer.write(this.jArtAlias, new Object[0]);
        writer.write(".query_id = ?", new Object[0]);
        writer.addParameter(this.criteria.getQueryId());
        Collection<Integer> ids = this.criteria.getIds();
        if (!ids.isEmpty()) {
            writer.write(" AND ", new Object[0]);
            if (ids.size() > 1) {
                this.joinIdQuery = writer.writeIdJoin(ids);
                writer.write(this.attrAlias, new Object[0]);
                writer.write(".attr_id = ", new Object[0]);
                writer.write(this.jIdAlias, new Object[0]);
                writer.write(".id AND ", new Object[0]);
                writer.write(this.jIdAlias, new Object[0]);
                writer.write(".query_id = ?", new Object[0]);
                writer.addParameter(this.joinIdQuery.getQueryId());
            } else {
                writer.write(this.attrAlias, new Object[0]);
                writer.write(".attr_id = ?", new Object[0]);
                writer.addParameter(ids.iterator().next());
            }
        }
        if (!(types = this.criteria.getTypes()).isEmpty()) {
            writer.write(" AND ", new Object[0]);
            if (types.size() > 1) {
                this.joinTypeQuery = writer.writeJoin(types);
                writer.write(this.attrAlias, new Object[0]);
                writer.write(".attr_type_id = ", new Object[0]);
                writer.write(this.jTypeIdAlias, new Object[0]);
                writer.write(".id AND ", new Object[0]);
                writer.write(this.jTypeIdAlias, new Object[0]);
                writer.write(".query_id = ?", new Object[0]);
                writer.addParameter(this.joinTypeQuery.getQueryId());
            } else {
                writer.write(this.attrAlias, new Object[0]);
                writer.write(".attr_type_id = ?", new Object[0]);
                writer.addParameter(types.iterator().next());
            }
        }
        writer.write(" AND ", new Object[0]);
        writer.write(this.attrAlias, new Object[0]);
        writer.write(".gamma_id = ", new Object[0]);
        writer.write(this.txsAlias, new Object[0]);
        writer.write(".gamma_id", new Object[0]);
        writer.write("\n AND ", new Object[0]);
        writer.write(writer.getTxBranchFilter(this.txsAlias), new Object[0]);
        return true;
    }
}

