/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.handlers;

import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaArtifact;
import org.eclipse.osee.orcs.db.internal.loader.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;

public class ArtifactSqlHandler
extends SqlHandler<CriteriaArtifact> {
    private CriteriaArtifact criteria;
    private String jArtAlias;
    private String artAlias;
    private String txsAlias;

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ARTIFACT_LOADER.ordinal();
    }

    @Override
    public void setData(CriteriaArtifact criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addSelect(AbstractSqlWriter writer) throws OseeCoreException {
        writer.write("%s.art_type_id, %s.guid", this.artAlias, this.artAlias);
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.jArtAlias = writer.addTable(TableEnum.JOIN_ID4_TABLE);
        this.artAlias = writer.addTable(TableEnum.ARTIFACT_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE);
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        writer.write(this.artAlias, new Object[0]);
        writer.write(".art_id = ", new Object[0]);
        writer.write(this.jArtAlias, new Object[0]);
        writer.write(".id2 AND ", new Object[0]);
        writer.write(this.jArtAlias, new Object[0]);
        writer.write(".query_id = ?", new Object[0]);
        writer.addParameter(this.criteria.getQueryId());
        writer.write(" AND ", new Object[0]);
        writer.write(this.artAlias, new Object[0]);
        writer.write(".gamma_id = ", new Object[0]);
        writer.write(this.txsAlias, new Object[0]);
        writer.write(".gamma_id", new Object[0]);
        writer.write("\n AND ", new Object[0]);
        writer.write(writer.getTxBranchFilter(this.txsAlias), new Object[0]);
        return true;
    }
}

