/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.executors;

import java.util.Collection;
import org.eclipse.osee.executor.admin.HasCancellation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.db.internal.loader.LoadSqlContext;
import org.eclipse.osee.orcs.db.internal.loader.LoadUtil;
import org.eclipse.osee.orcs.db.internal.loader.SqlObjectLoader;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaOrcsLoad;
import org.eclipse.osee.orcs.db.internal.loader.executors.AbstractLoadExecutor;
import org.eclipse.osee.orcs.db.internal.sql.join.CharJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.Id4JoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class UuidsLoadExecutor
extends AbstractLoadExecutor {
    private static final String GUIDS_TO_IDS = "SELECT art.art_id FROM osee_join_char_id jid, osee_artifact art WHERE jid.query_id = ? AND jid.id = art.guid";
    private final SqlJoinFactory joinFactory;
    private final OrcsSession session;
    private final BranchId branch;
    private final Collection<String> artifactIds;

    public UuidsLoadExecutor(SqlObjectLoader loader, JdbcClient jdbcClient, SqlJoinFactory joinFactory, OrcsSession session, BranchId branch, Collection<String> artifactIds) {
        super(loader, jdbcClient);
        this.joinFactory = joinFactory;
        this.session = session;
        this.branch = branch;
        this.artifactIds = artifactIds;
    }

    @Override
    public void load(HasCancellation cancellation, LoadDataHandler handler, CriteriaOrcsLoad criteria, Options options) throws OseeCoreException {
        this.checkCancelled(cancellation);
        if (!this.artifactIds.isEmpty()) {
            Id4JoinQuery join = this.createIdJoin(this.getJdbcClient(), options);
            LoadSqlContext loadContext = new LoadSqlContext(this.session, options, this.branch);
            int fetchSize = LoadUtil.computeFetchSize(this.artifactIds.size());
            this.getLoader().loadArtifacts(cancellation, handler, join, criteria, loadContext, fetchSize);
        }
    }

    private Id4JoinQuery createIdJoin(JdbcClient jdbcClient, Options options) throws OseeCoreException {
        Id4JoinQuery toReturn = this.joinFactory.createId4JoinQuery();
        CharJoinQuery guidJoin = this.joinFactory.createCharJoinQuery();
        try {
            for (String id : this.artifactIds) {
                guidJoin.add(id);
            }
            guidJoin.store();
            TransactionId transactionId = OptionsUtil.getFromTransaction((Options)options);
            this.getJdbcClient().runQuery(stmt -> {
                Integer artId = stmt.getInt("art_id");
                toReturn.add((Id)this.branch, (Id)ArtifactId.valueOf((long)artId.intValue()), (Id)transactionId);
            }, this.artifactIds.size(), GUIDS_TO_IDS, new Object[]{guidJoin.getQueryId()});
        }
        finally {
            guidJoin.delete();
        }
        return toReturn;
    }
}

