/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.data;

import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.orcs.core.ds.VersionData;

public class VersionDataImpl
implements VersionData {
    private BranchId branch = BranchId.SENTINEL;
    private TransactionId txId = TransactionId.SENTINEL;
    private long gamma = -1L;
    private boolean historical = false;
    private TransactionId stripeId = TransactionId.SENTINEL;

    public long getGammaId() {
        return this.gamma;
    }

    public void setGammaId(long gamma) {
        this.gamma = gamma;
    }

    public TransactionId getTransactionId() {
        return this.txId;
    }

    public void setTransactionId(TransactionId txId) {
        this.txId = txId;
    }

    public TransactionId getStripeId() {
        return this.stripeId;
    }

    public void setStripeId(TransactionId stripeId) {
        this.stripeId = stripeId;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public void setBranch(BranchId branch) {
        this.branch = branch;
    }

    public boolean isInStorage() {
        return TransactionId.SENTINEL != this.txId;
    }

    public boolean isHistorical() {
        return this.historical;
    }

    public void setHistorical(boolean historical) {
        this.historical = historical;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.branch.hashCode();
        result = 31 * result + (int)(this.gamma ^ this.gamma >>> 32);
        result = 31 * result + (this.historical ? 1231 : 1237);
        result = 31 * result + this.stripeId.hashCode();
        result = 31 * result + this.txId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionDataImpl other = (VersionDataImpl)obj;
        if (!this.branch.equals(other.branch)) {
            return false;
        }
        if (this.gamma != other.gamma) {
            return false;
        }
        if (this.historical != other.historical) {
            return false;
        }
        if (this.stripeId != other.stripeId) {
            return false;
        }
        return this.txId == other.txId;
    }

    public String toString() {
        return "Version [branch=" + this.branch + ", txId=" + this.txId + ", gamma=" + this.gamma + ", historical=" + this.historical + ", stripeId=" + this.stripeId + "]";
    }

    public VersionData clone() {
        VersionDataImpl copy = new VersionDataImpl();
        copy.setBranch(this.getBranch());
        copy.setGammaId(this.getGammaId());
        copy.setHistorical(this.isHistorical());
        copy.setStripeId(this.getStripeId());
        copy.setTransactionId(this.getTransactionId());
        return copy;
    }
}

