/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.data;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.RelationalConstants;
import org.eclipse.osee.framework.core.enums.DirtyState;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.orcs.core.ds.OrcsData;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.db.internal.loader.data.OrcsObjectImpl;

public abstract class OrcsVersionedObjectImpl
extends OrcsObjectImpl<Integer>
implements OrcsData {
    private long typeUuid = -1L;
    private long baseTypeUuid = -1L;
    private ModificationType baseModType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
    private ModificationType previousModType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
    private ModificationType currentModType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
    private final VersionData version;
    private ApplicabilityId applicId;
    private boolean applicDirty;
    private DirtyState dirtyState = DirtyState.CLEAN;

    protected OrcsVersionedObjectImpl(VersionData version) {
        this.version = version;
    }

    public long getTypeUuid() {
        return this.typeUuid;
    }

    public void setTypeUuid(long typeUuid) {
        this.typeUuid = typeUuid;
    }

    public long getBaseTypeUuid() {
        return this.baseTypeUuid;
    }

    public void setBaseTypeUuid(long baseTypeUuid) {
        this.baseTypeUuid = baseTypeUuid;
    }

    public void setBaseModType(ModificationType modType) {
        this.baseModType = modType;
    }

    public ModificationType getModType() {
        return this.currentModType;
    }

    public void setModType(ModificationType modType) {
        this.previousModType = this.currentModType;
        this.currentModType = modType;
    }

    public ModificationType getPreviousModType() {
        return this.previousModType;
    }

    public ModificationType getBaseModType() {
        return this.baseModType;
    }

    public boolean hasTypeUuidChange() {
        return this.getBaseTypeUuid() != this.getTypeUuid();
    }

    public boolean hasModTypeChange() {
        return this.getBaseModType() != this.getModType();
    }

    public VersionData getVersion() {
        return this.version;
    }

    public void setApplicabilityId(ApplicabilityId applicId) {
        if (this.applicId != null && !this.applicId.equals(applicId) && !this.dirtyState.isDirty()) {
            this.applicDirty = true;
            this.dirtyState = DirtyState.APPLICABILITY_ONLY;
        }
        this.applicId = applicId;
    }

    public ApplicabilityId getApplicabilityId() {
        return this.applicId;
    }

    public DirtyState getDirtyState() {
        return this.dirtyState;
    }

    public boolean isDirty() {
        return this.dirtyState.isDirty();
    }

    public DirtyState calculateDirtyState(boolean dirty) {
        if (!dirty) {
            this.dirtyState = this.applicDirty ? DirtyState.APPLICABILITY_ONLY : DirtyState.CLEAN;
        } else if (dirty) {
            this.dirtyState = DirtyState.OTHER_CHANGES;
            return this.dirtyState;
        }
        return this.dirtyState;
    }

    public int hashCode() {
        int result = ((Integer)this.getLocalId()).hashCode();
        result = 31 * result + (this.baseModType == null ? 0 : this.baseModType.hashCode());
        result = 31 * result + Long.hashCode(this.baseTypeUuid);
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OrcsVersionedObjectImpl) {
            OrcsVersionedObjectImpl other = (OrcsVersionedObjectImpl)obj;
            if (!((Integer)this.getLocalId()).equals(other.getLocalId())) {
                return false;
            }
            if (this.baseModType != other.baseModType) {
                return false;
            }
            if (this.baseTypeUuid != other.baseTypeUuid) {
                return false;
            }
            if (this.version == null) {
                if (other.version != null) {
                    return false;
                }
                return this.version.equals(other.version);
            }
            return true;
        }
        if (obj instanceof Id) {
            return ((Id)obj).getId().equals(((Integer)this.getLocalId()).longValue());
        }
        return false;
    }

    @Override
    public String toString() {
        return "OrcsVersionedObject [" + super.toString() + ", typeUuid=" + this.typeUuid + ", baseTypeUuid=" + this.baseTypeUuid + ", modType=" + this.currentModType + ", previousModType=" + this.previousModType + ", baseModType=" + this.baseModType + ", version=" + this.version + "]";
    }
}

