/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.data;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.orcs.core.ds.BranchData;
import org.eclipse.osee.orcs.data.BranchReadable;

public class BranchDataImpl
extends NamedIdBase
implements BranchData,
BranchReadable {
    private ArtifactId associatedArtifact = ArtifactId.SENTINEL;
    private TransactionId baseTransaction = TransactionId.SENTINEL;
    private TransactionId sourceTransaction = TransactionId.SENTINEL;
    private BranchId parentBranch = BranchId.SENTINEL;
    private BranchArchivedState archiveState = BranchArchivedState.UNARCHIVED;
    private BranchState branchState = BranchState.CREATED;
    private BranchType branchType = BranchType.WORKING;
    private boolean inheritAccessControl = false;
    private ArtifactId viewId = ArtifactId.SENTINEL;

    public BranchDataImpl(BranchId branch, String name) {
        this(branch, name, ArtifactId.SENTINEL);
    }

    public BranchDataImpl(BranchId branch, String name, ArtifactId viewId) {
        super(branch.getId(), name);
        this.viewId = viewId;
    }

    public ArtifactId getAssociatedArtifact() {
        return this.associatedArtifact;
    }

    public void setAssociatedArtifact(ArtifactId associatedArtifact) {
        this.associatedArtifact = associatedArtifact;
    }

    public TransactionId getBaseTransaction() {
        return this.baseTransaction;
    }

    public void setBaseTransaction(TransactionId baseTx) {
        this.baseTransaction = baseTx;
    }

    public TransactionId getSourceTransaction() {
        return this.sourceTransaction;
    }

    public void setSourceTransaction(TransactionId sourceTx) {
        this.sourceTransaction = sourceTx;
    }

    public BranchId getParentBranch() {
        return this.parentBranch;
    }

    public void setParentBranch(BranchId parent) {
        this.parentBranch = parent;
    }

    public boolean hasParentBranch() {
        return this.getParentBranch().isValid();
    }

    public BranchArchivedState getArchiveState() {
        return this.archiveState;
    }

    public void setArchiveState(BranchArchivedState state) {
        this.archiveState = state;
    }

    public BranchState getBranchState() {
        return this.branchState;
    }

    public void setBranchState(BranchState state) {
        this.branchState = state;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public void setBranchType(BranchType type) {
        this.branchType = type;
    }

    public String toString() {
        return "BranchData [uuid=" + this.getId() + ", " + super.toString() + "]";
    }

    public boolean isInheritAccessControl() {
        return this.inheritAccessControl;
    }

    public void setInheritAccessControl(boolean inheritAccessControl) {
        this.inheritAccessControl = inheritAccessControl;
    }

    public ArtifactId getViewId() {
        return this.viewId;
    }
}

