/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader;

import java.util.concurrent.CancellationException;
import org.eclipse.osee.executor.admin.HasCancellation;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.BranchData;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.LoadDescription;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.OrcsDataHandler;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.ResultObjectDescription;
import org.eclipse.osee.orcs.core.ds.TxOrcsData;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.OrcsObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.LoadSqlContext;
import org.eclipse.osee.orcs.db.internal.loader.LoadSqlWriter;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaOrcsLoad;
import org.eclipse.osee.orcs.db.internal.loader.processor.AbstractLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.ArtifactLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.AttributeLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.BranchLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.DynamicLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.RelationLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.TransactionLoadProcessor;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.Id4JoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class SqlObjectLoader {
    private final BranchLoadProcessor branchProcessor;
    private final TransactionLoadProcessor txProcessor;
    private final ArtifactLoadProcessor artifactProcessor;
    private final AttributeLoadProcessor attributeProcessor;
    private final RelationLoadProcessor relationProcessor;
    private final DynamicLoadProcessor dynamicProcessor;
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;
    private final SqlHandlerFactory handlerFactory;

    public SqlObjectLoader(Log logger, JdbcClient jdbcClient, SqlJoinFactory joinFactory, SqlHandlerFactory handlerFactory, OrcsObjectFactory objectFactory, DynamicLoadProcessor dynamicProcessor, AttributeTypes attributeTypes) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.handlerFactory = handlerFactory;
        this.dynamicProcessor = dynamicProcessor;
        this.artifactProcessor = new ArtifactLoadProcessor(objectFactory);
        this.attributeProcessor = new AttributeLoadProcessor(logger, objectFactory, attributeTypes);
        this.relationProcessor = new RelationLoadProcessor(logger, objectFactory);
        this.branchProcessor = new BranchLoadProcessor(objectFactory);
        this.txProcessor = new TransactionLoadProcessor(objectFactory);
    }

    public SqlHandlerFactory getFactory() {
        return this.handlerFactory;
    }

    public JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    private void checkCancelled(HasCancellation cancellation) throws CancellationException {
        if (cancellation != null) {
            cancellation.checkForCancelled();
        }
    }

    private boolean isAttributeLoadingAllowed(LoadLevel level) {
        return level != LoadLevel.ARTIFACT_DATA && level != LoadLevel.RELATION_DATA;
    }

    private boolean isRelationLoadingAllowed(LoadLevel level) {
        return level != LoadLevel.ARTIFACT_DATA && level != LoadLevel.ARTIFACT_AND_ATTRIBUTE_DATA;
    }

    private void writeSql(Criteria criteria, LoadSqlContext context) throws OseeCoreException {
        context.clear();
        SqlHandler<?> handler = this.handlerFactory.createHandler(criteria);
        LoadSqlWriter writer = new LoadSqlWriter(this.logger, this.joinFactory, this.jdbcClient, context);
        writer.build(handler);
    }

    public void loadArtifacts(HasCancellation cancellation, LoadDataHandler handler, Id4JoinQuery join, CriteriaOrcsLoad criteria, LoadSqlContext loadContext, int fetchSize) throws OseeCoreException {
        this.logger.trace("Sql Artifact Load - artifactJoinQuery[%s] loadSqlContext[%s]", new Object[]{join, loadContext});
        if (!join.isEmpty()) {
            try {
                join.store();
                criteria.setQueryId(join.getQueryId());
                this.loadArtifacts(cancellation, handler, criteria, loadContext, fetchSize);
            }
            finally {
                join.delete();
            }
        } else {
            this.logger.trace("Sql Artifact Load - artifactJoinQuery was empty - skipping load - loadSqlContext[%s]", new Object[]{loadContext});
        }
    }

    public void loadBranches(HasCancellation cancellation, LoadDataHandler handler, QuerySqlContext context, int fetchSize) throws OseeCoreException {
        this.logger.trace("Sql Branch Load - loadContext[%s] fetchSize[%s]", new Object[]{context, fetchSize});
        this.checkCancelled(cancellation);
        LoadDescription description = SqlObjectLoader.createDescription(context.getSession(), context.getOptions());
        handler.onLoadDescription(description);
        OrcsDataHandler<BranchData> branchHandler = SqlObjectLoader.asBranchHandler(handler);
        this.load(this.branchProcessor, branchHandler, context, fetchSize);
    }

    public void loadTransactions(HasCancellation cancellation, LoadDataHandler handler, QuerySqlContext context, int fetchSize) throws OseeCoreException {
        this.logger.trace("Sql Transaction Load - loadContext[%s] fetchSize[%s]", new Object[]{context, fetchSize});
        this.checkCancelled(cancellation);
        LoadDescription description = SqlObjectLoader.createDescription(context.getSession(), context.getOptions());
        handler.onLoadDescription(description);
        OrcsDataHandler<TxOrcsData> txHandler = SqlObjectLoader.asTransactionHandler(handler);
        this.load(this.txProcessor, txHandler, context, fetchSize);
    }

    public void loadDynamicObjects(HasCancellation cancellation, LoadDataHandler handler, QuerySqlContext context, int fetchSize) throws OseeCoreException {
        this.logger.trace("Sql Transaction Load - loadContext[%s] fetchSize[%s]", new Object[]{context, fetchSize});
        this.checkCancelled(cancellation);
        Options options = context.getOptions();
        options.put("sql", context.getSql());
        options.put("parameters", context.getParameters().toString());
        options.put("result.descriptor", (Object)context.getObjectDescription());
        LoadDescription description = SqlObjectLoader.createDescription(context.getSession(), options, context.getObjectDescription());
        handler.onLoadDescription(description);
        this.load(this.dynamicProcessor, handler, context, fetchSize);
        options.remove("result.descriptor");
    }

    private void loadArtifacts(HasCancellation cancellation, LoadDataHandler handler, CriteriaOrcsLoad criteria, LoadSqlContext loadContext, int fetchSize) throws OseeCoreException {
        this.checkCancelled(cancellation);
        this.loadDescription(handler, loadContext);
        this.checkCancelled(cancellation);
        this.loadArtifacts(handler, criteria.getArtifactCriteria(), loadContext, fetchSize);
        this.checkCancelled(cancellation);
        this.loadAttributes(handler, criteria.getAttributeCriteria(), loadContext, fetchSize);
        this.checkCancelled(cancellation);
        this.loadRelations(handler, criteria.getRelationCriteria(), loadContext, fetchSize);
    }

    protected void loadDescription(LoadDataHandler builder, LoadSqlContext loadContext) throws OseeCoreException {
        OrcsSession session = loadContext.getSession();
        Options options = loadContext.getOptions();
        BranchId branch = loadContext.getBranch();
        TransactionId transactionLoaded = OptionsUtil.isHeadTransaction((Options)options) ? this.loadHeadTransactionId(branch) : OptionsUtil.getFromTransaction((Options)options);
        LoadDescription description = SqlObjectLoader.createDescription(session, options, branch, transactionLoaded);
        builder.onLoadDescription(description);
    }

    protected void loadArtifacts(LoadDataHandler handler, Criteria criteria, LoadSqlContext loadContext, int fetchSize) throws OseeCoreException {
        OrcsDataHandler<ArtifactData> artHandler = SqlObjectLoader.asArtifactHandler(handler);
        this.writeSql(criteria, loadContext);
        this.load(this.artifactProcessor, artHandler, loadContext, fetchSize);
    }

    protected void loadAttributes(LoadDataHandler handler, Criteria criteria, LoadSqlContext loadContext, int fetchSize) throws OseeCoreException {
        LoadLevel loadLevel = OptionsUtil.getLoadLevel((Options)loadContext.getOptions());
        if (this.isAttributeLoadingAllowed(loadLevel)) {
            OrcsDataHandler<AttributeData> attrHandler = SqlObjectLoader.asAttributeHandler(handler);
            this.writeSql(criteria, loadContext);
            this.load(this.attributeProcessor, attrHandler, loadContext, fetchSize);
        }
    }

    protected void loadRelations(LoadDataHandler handler, Criteria criteria, LoadSqlContext loadContext, int fetchSize) throws OseeCoreException {
        LoadLevel loadLevel = OptionsUtil.getLoadLevel((Options)loadContext.getOptions());
        if (this.isRelationLoadingAllowed(loadLevel)) {
            OrcsDataHandler<RelationData> relHandler = SqlObjectLoader.asRelationHandler(handler);
            this.writeSql(criteria, loadContext);
            this.load(this.relationProcessor, relHandler, loadContext, fetchSize);
        }
    }

    protected TransactionId loadHeadTransactionId(BranchId branch) throws OseeCoreException {
        String sql = "SELECT max(transaction_id) FROM osee_tx_details WHERE branch_id = ?";
        return (TransactionId)this.getJdbcClient().fetch((Object)TransactionId.SENTINEL, sql, new Object[]{branch});
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <H> void load(AbstractLoadProcessor<H> processor, H handler, SqlContext loadContext, int fetchSize) throws OseeCoreException {
        block18: {
            var6_5 = loadContext.getJoins().iterator();
            while (true) {
                if (!var6_5.hasNext()) {
                    startTime = System.currentTimeMillis();
                    var7_8 = null;
                    var8_10 = null;
                    ** try [egrp 1[TRYBLOCK] [1 : 54->257)] { 
lbl9:
                    // 1 sources

                    break;
                }
                join = var6_5.next();
                join.store();
            }
            {
                chStmt = this.getJdbcClient().getStatement();
                try {
                    chStmt.runPreparedQuery(fetchSize, loadContext.getSql(), loadContext.getParameters().toArray());
                    processorName = null;
                    if (this.logger.isTraceEnabled()) {
                        processorName = processor.getClass().getSimpleName();
                        this.logger.trace("Sql Artifact Load [%s] - [%s] fetchSize[%s] context[%s] ", new Object[]{Lib.getElapseString((long)startTime), processorName, fetchSize, loadContext});
                        startTime = System.currentTimeMillis();
                    }
                    rowCount = processor.processResultSet(handler, chStmt, loadContext.getOptions());
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Sql Artifact Load [%s] - [%s] processed [%d] rows", new Object[]{Lib.getElapseString((long)startTime), processorName, rowCount});
                    }
                    if (chStmt == null) break block18;
                }
                catch (Throwable var7_9) {
                    if (chStmt == null) throw var7_9;
                    chStmt.close();
                    throw var7_9;
                }
                chStmt.close();
            }
lbl32:
            // 1 sources

            catch (Throwable var8_11) {
                if (var7_8 == null) {
                    var7_8 = var8_11;
                    throw var7_8;
                }
                if (var7_8 == var8_11) throw var7_8;
                var7_8.addSuppressed(var8_11);
                throw var7_8;
            }
            finally {
                var14_17 = loadContext.getJoins().iterator();
                break;
            }
        }
        while (true) {
            if (!var14_17.hasNext()) {
                return;
            }
            join = var14_17.next();
            try {
                join.delete();
            }
            catch (Exception v0) {}
        }
    }

    private static LoadDescription createDescription(OrcsSession session, Options options) {
        return SqlObjectLoader.createDescription(session, options, null, TransactionId.SENTINEL, null);
    }

    private static LoadDescription createDescription(OrcsSession session, Options options, ResultObjectDescription data) {
        return SqlObjectLoader.createDescription(session, options, null, TransactionId.SENTINEL, data);
    }

    private static LoadDescription createDescription(OrcsSession session, Options options, BranchId branch, TransactionId transactionLoaded) {
        return SqlObjectLoader.createDescription(session, options, branch, transactionLoaded, null);
    }

    private static LoadDescription createDescription(final OrcsSession session, final Options options, final BranchId branch, final TransactionId transactionLoaded, final ResultObjectDescription data) {
        return new LoadDescription(){

            public OrcsSession getSession() {
                return session;
            }

            public Options getOptions() {
                return options;
            }

            public BranchId getBranch() {
                return branch;
            }

            public TransactionId getTransaction() {
                return transactionLoaded;
            }

            public boolean isMultiBranch() {
                return this.getBranch() == null;
            }

            public ResultObjectDescription getObjectDescription() {
                return data;
            }
        };
    }

    private static OrcsDataHandler<ArtifactData> asArtifactHandler(final LoadDataHandler handler) {
        return new OrcsDataHandler<ArtifactData>(){

            public void onData(ArtifactData data) throws OseeCoreException {
                handler.onData(data);
            }
        };
    }

    private static OrcsDataHandler<AttributeData> asAttributeHandler(final LoadDataHandler handler) {
        return new OrcsDataHandler<AttributeData>(){

            public void onData(AttributeData data) throws OseeCoreException {
                handler.onData(data);
            }
        };
    }

    private static OrcsDataHandler<RelationData> asRelationHandler(final LoadDataHandler handler) {
        return new OrcsDataHandler<RelationData>(){

            public void onData(RelationData data) throws OseeCoreException {
                handler.onData(data);
            }
        };
    }

    private static OrcsDataHandler<BranchData> asBranchHandler(final LoadDataHandler handler) {
        return new OrcsDataHandler<BranchData>(){

            public void onData(BranchData data) throws OseeCoreException {
                handler.onData(data);
            }
        };
    }

    private static OrcsDataHandler<TxOrcsData> asTransactionHandler(final LoadDataHandler handler) {
        return new OrcsDataHandler<TxOrcsData>(){

            public void onData(TxOrcsData data) throws OseeCoreException {
                handler.onData(data);
            }
        };
    }
}

