/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader;

import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.DataFactory;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.OrcsObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.AttributeDataProxyFactory;
import org.eclipse.osee.orcs.db.internal.loader.DataFactoryImpl;
import org.eclipse.osee.orcs.db.internal.loader.DataLoaderFactoryImpl;
import org.eclipse.osee.orcs.db.internal.loader.DataProxyFactoryProvider;
import org.eclipse.osee.orcs.db.internal.loader.ProxyDataFactory;
import org.eclipse.osee.orcs.db.internal.loader.SqlObjectLoader;
import org.eclipse.osee.orcs.db.internal.loader.data.OrcsObjectFactoryImpl;
import org.eclipse.osee.orcs.db.internal.loader.handlers.LoaderSqlHandlerFactoryUtil;
import org.eclipse.osee.orcs.db.internal.loader.processor.DynamicLoadProcessor;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class LoaderModule {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final IdentityManager idFactory;
    private final DataProxyFactoryProvider proxyProvider;
    private final SqlJoinFactory joinFactory;

    public LoaderModule(Log logger, JdbcClient jdbcClient, IdentityManager idFactory, DataProxyFactoryProvider proxyProvider, SqlJoinFactory joinFactory) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.idFactory = idFactory;
        this.proxyProvider = proxyProvider;
        this.joinFactory = joinFactory;
    }

    public ProxyDataFactory createProxyDataFactory(AttributeTypes attributeTypes) {
        return new AttributeDataProxyFactory(this.proxyProvider, this.jdbcClient, attributeTypes);
    }

    public OrcsObjectFactory createOrcsObjectFactory(ProxyDataFactory proxyFactory) {
        return new OrcsObjectFactoryImpl(proxyFactory);
    }

    public DataFactory createDataFactory(OrcsObjectFactory factory, ArtifactTypes artifactTypes) {
        return new DataFactoryImpl(this.idFactory, factory, artifactTypes);
    }

    public DataLoaderFactory createDataLoaderFactory(OrcsObjectFactory objectFactory, DynamicLoadProcessor dynamicLoadProcessor, AttributeTypes attributeTypes) {
        SqlObjectLoader sqlObjectLoader = this.createSqlObjectLoader(objectFactory, dynamicLoadProcessor, attributeTypes);
        return this.createDataLoaderFactory(sqlObjectLoader);
    }

    public DynamicLoadProcessor createDynamicLoadProcessor(OrcsTypes orcsTypes, ProxyDataFactory proxyFactory) {
        return new DynamicLoadProcessor(this.logger, orcsTypes, proxyFactory);
    }

    public DataLoaderFactory createDataLoaderFactory(SqlObjectLoader sqlObjectLoader) {
        return new DataLoaderFactoryImpl(this.logger, this.jdbcClient, sqlObjectLoader, this.joinFactory);
    }

    protected SqlObjectLoader createSqlObjectLoader(OrcsObjectFactory objectFactory, DynamicLoadProcessor dynamicLoadProcessor, AttributeTypes attributeTypes) {
        SqlHandlerFactory handlerFactory = LoaderSqlHandlerFactoryUtil.createHandlerFactory(this.logger, this.idFactory);
        return new SqlObjectLoader(this.logger, this.jdbcClient, this.joinFactory, handlerFactory, objectFactory, dynamicLoadProcessor, attributeTypes);
    }
}

