/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader;

import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.QueryType;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class LoadSqlWriter
extends AbstractSqlWriter {
    public LoadSqlWriter(Log logger, SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlContext context) {
        super(logger, joinFactory, jdbcClient, context, QueryType.SELECT);
    }

    @Override
    public void writeSelect(Iterable<SqlHandler<?>> handlers) throws OseeCoreException {
        String txAlias = this.getLastAlias(TableEnum.TXS_TABLE);
        String artJoinAlias = this.getLastAlias(TableEnum.JOIN_ID4_TABLE);
        this.write("SELECT%s ", this.getSqlHint());
        this.write("%s.gamma_id, %s.mod_type, %s.branch_id, %s.transaction_id, %s.app_id", txAlias, txAlias, txAlias, txAlias, txAlias);
        if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            this.write(", %s.transaction_id as stripe_transaction_id", txAlias);
        }
        this.write(",\n %s.id2, %s.id4", artJoinAlias, artJoinAlias);
        for (SqlHandler<?> handler : handlers) {
            this.setHandlerLevel(handler);
            this.write(", ", new Object[0]);
            handler.addSelect(this);
        }
    }

    @Override
    public void writeGroupAndOrder() throws OseeCoreException {
        String artAlias = this.getLastAlias(TableEnum.JOIN_ID4_TABLE);
        String txAlias = this.getLastAlias(TableEnum.TXS_TABLE);
        this.write("\n ORDER BY %s.branch_id, %s.id2", txAlias, artAlias);
        if (this.hasAlias(TableEnum.ATTRIBUTE_TABLE)) {
            this.write(", %s.attr_id", this.getLastAlias(TableEnum.ATTRIBUTE_TABLE));
        }
        if (this.hasAlias(TableEnum.RELATION_TABLE)) {
            this.write(", %s.rel_link_id", this.getLastAlias(TableEnum.RELATION_TABLE));
        }
        this.write(", %s.transaction_id desc", txAlias);
    }

    @Override
    public String getTxBranchFilter(String txsAlias) {
        boolean allowDeletedAtrifacts = OptionsUtil.areDeletedArtifactsIncluded((Options)this.getOptions());
        boolean allowDeletedAttributes = OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions());
        boolean allowDeletedRelations = OptionsUtil.areDeletedRelationsIncluded((Options)this.getOptions());
        boolean areDeletedIncluded = allowDeletedAtrifacts || allowDeletedAttributes || allowDeletedRelations;
        return this.getTxBranchFilter(txsAlias, areDeletedIncluded);
    }

    @Override
    public String getTxBranchFilter(String txsAlias, boolean allowDeleted) {
        StringBuilder sb = new StringBuilder();
        String artJoinAlias = this.getLastAlias(TableEnum.JOIN_ID4_TABLE);
        this.writeTxFilter(txsAlias, artJoinAlias, sb, allowDeleted);
        sb.append(" AND ");
        sb.append(txsAlias);
        sb.append(".branch_id = ");
        sb.append(artJoinAlias);
        sb.append(".id1");
        return sb.toString();
    }

    private void writeTxFilter(String txsAlias, String artJoinAlias, StringBuilder sb, boolean areDeletedIncluded) {
        boolean[] hasTable = new boolean[]{this.hasAlias(TableEnum.ARTIFACT_TABLE), this.hasAlias(TableEnum.ATTRIBUTE_TABLE), this.hasAlias(TableEnum.RELATION_TABLE)};
        boolean areDeletedSame = true;
        if (areDeletedIncluded) {
            int count = 0;
            boolean[] blArray = hasTable;
            int n = hasTable.length;
            int n2 = 0;
            while (n2 < n) {
                boolean add = blArray[n2];
                if (add) {
                    ++count;
                }
                ++n2;
            }
            if (count > 1) {
                boolean allowDeletedAtrifacts = OptionsUtil.areDeletedArtifactsIncluded((Options)this.getOptions());
                boolean allowDeletedAttributes = OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions());
                boolean allowDeletedRelations = OptionsUtil.areDeletedRelationsIncluded((Options)this.getOptions());
                boolean bl = areDeletedSame = !(hasTable[0] && !allowDeletedAtrifacts || hasTable[1] && !allowDeletedAttributes || hasTable[2] && !allowDeletedRelations);
            }
        }
        if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            sb.append(txsAlias);
            sb.append(".transaction_id <= ");
            sb.append(artJoinAlias);
            sb.append(".id3");
            if (!areDeletedIncluded) {
                sb.append(" AND ");
                sb.append(txsAlias);
                sb.append(".mod_type");
                sb.append(" != ");
                sb.append(String.valueOf(ModificationType.DELETED.getValue()));
            } else if (!areDeletedSame) {
                sb.append(" AND ");
                this.buildDeletedClause(sb, txsAlias);
            }
        } else if (areDeletedIncluded) {
            if (areDeletedSame) {
                sb.append(txsAlias);
                sb.append(".tx_current");
                sb.append(" IN (");
                sb.append(String.valueOf(TxChange.CURRENT.getValue()));
                sb.append(", ");
                sb.append(String.valueOf(TxChange.DELETED.getValue()));
                sb.append(", ");
                sb.append(String.valueOf(TxChange.ARTIFACT_DELETED.getValue()));
                sb.append(")");
            } else {
                this.buildDeletedClause(sb, txsAlias);
            }
        } else {
            sb.append(txsAlias);
            sb.append(".tx_current = ");
            sb.append(String.valueOf(TxChange.CURRENT.getValue()));
        }
    }

    @Override
    public Options getOptions() {
        return this.getContext().getOptions();
    }

    private void buildDeletedClause(StringBuilder sb, String txsAlias) {
        int count = 0;
        if (this.hasAlias(TableEnum.ARTIFACT_TABLE)) {
            List<String> artTables = this.getAliases(TableEnum.ARTIFACT_TABLE);
            if (OptionsUtil.areDeletedArtifactsIncluded((Options)this.getOptions())) {
                sb.append("(");
                this.buildTableGamma(sb, artTables, txsAlias);
                sb.append(" AND ");
                this.buildTxClause(sb, txsAlias);
                sb.append(")");
                ++count;
            }
        }
        if (this.hasAlias(TableEnum.ATTRIBUTE_TABLE)) {
            List<String> attrTables = this.getAliases(TableEnum.ATTRIBUTE_TABLE);
            if (OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions())) {
                if (count > 1) {
                    sb.append(" AND ");
                }
                sb.append("(");
                this.buildTableGamma(sb, attrTables, txsAlias);
                sb.append(" AND ");
                this.buildTxClause(sb, txsAlias);
                sb.append(")");
                ++count;
            }
        }
        if (this.hasAlias(TableEnum.RELATION_TABLE)) {
            List<String> relationTables = this.getAliases(TableEnum.RELATION_TABLE);
            if (OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions())) {
                if (count > 1) {
                    sb.append(" AND ");
                }
                sb.append("(");
                this.buildTableGamma(sb, relationTables, txsAlias);
                sb.append(" AND ");
                this.buildTxClause(sb, txsAlias);
                sb.append(")");
                ++count;
            }
        }
    }

    private void buildTableGamma(StringBuilder sb, List<String> tableAliases, String txsAlias) {
        if (tableAliases.size() == 1) {
            sb.append(tableAliases.get(0));
            sb.append(".gamma_id = ");
            sb.append(txsAlias);
            sb.append(".gamma_id");
        } else {
            Iterator<String> iter = tableAliases.iterator();
            iter.next();
            sb.append("(");
            sb.append(iter);
            sb.append(".gamma_id = ");
            sb.append(txsAlias);
            sb.append(".gamma_id");
            while (iter.hasNext()) {
                iter.next();
                sb.append(" OR ");
                sb.append(iter);
                sb.append(".gamma_id = ");
                sb.append(txsAlias);
                sb.append(".gamma_id");
            }
            sb.append(")");
        }
    }

    private void buildTxClause(StringBuilder sb, String txsAlias) {
        sb.append(txsAlias);
        if (!OptionsUtil.isHistorical((Options)this.getOptions())) {
            sb.append(".tx_current = ");
            sb.append(String.valueOf(TxChange.CURRENT.getValue()));
        }
    }

    @Override
    public String getWithClauseTxBranchFilter(String txsAlias, boolean deletedPredicate) throws OseeCoreException {
        return Strings.emptyString();
    }
}

