/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.executor.admin.HasCancellation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.DataLoader;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.db.internal.loader.SqlObjectLoader;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaArtifact;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaAttribute;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaOrcsLoad;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaRelation;
import org.eclipse.osee.orcs.db.internal.loader.executors.AbstractLoadExecutor;
import org.eclipse.osee.orcs.db.internal.loader.executors.LoadExecutor;
import org.eclipse.osee.orcs.db.internal.loader.executors.UuidsLoadExecutor;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class DataLoaderImpl
implements DataLoader {
    private final Collection<Integer> attributeIds = new HashSet<Integer>();
    private final Collection<AttributeTypeId> attributeTypes = new HashSet<AttributeTypeId>();
    private final Collection<Integer> relationIds = new HashSet<Integer>();
    private final Collection<IRelationType> relationTypes = new HashSet<IRelationType>();
    private final Log logger;
    private AbstractLoadExecutor loadExecutor;
    private final Options options;
    private final OrcsSession session;
    private final BranchId branchId;
    private final SqlObjectLoader sqlLoader;
    private final SqlJoinFactory joinFactory;

    public DataLoaderImpl(Log logger, AbstractLoadExecutor loadExecutor, Options options, OrcsSession session, BranchId branch, SqlObjectLoader sqlLoader, SqlJoinFactory joinFactory) {
        this(logger, options, session, branch, sqlLoader, joinFactory);
        this.loadExecutor = loadExecutor;
    }

    public DataLoaderImpl(Log logger, Collection<Integer> artifactIds, Options options, OrcsSession session, BranchId branch, SqlObjectLoader sqlLoader, SqlJoinFactory joinFactory) {
        this(logger, options, session, branch, sqlLoader, joinFactory);
        this.withArtifactIds(artifactIds);
    }

    public DataLoaderImpl(Log logger, Options options, OrcsSession session, BranchId branch, SqlObjectLoader sqlLoader, Collection<String> artifactIds, SqlJoinFactory joinFactory) {
        this(logger, options, session, branch, sqlLoader, joinFactory);
        this.withArtifactGuids(artifactIds);
    }

    private DataLoaderImpl(Log logger, Options options, OrcsSession session, BranchId branch, SqlObjectLoader sqlLoader, SqlJoinFactory joinFactory) {
        this.logger = logger;
        this.options = options;
        this.session = session;
        this.branchId = branch;
        this.sqlLoader = sqlLoader;
        this.joinFactory = joinFactory;
    }

    public DataLoader resetToDefaults() {
        OptionsUtil.reset((Options)this.getOptions());
        this.attributeIds.clear();
        this.attributeTypes.clear();
        this.relationIds.clear();
        this.relationTypes.clear();
        return this;
    }

    private Options getOptions() {
        return this.options;
    }

    public DataLoader setOptions(Options source) {
        this.getOptions().setFrom(source);
        return this;
    }

    public DataLoader includeDeletedArtifacts() {
        this.includeDeletedArtifacts(true);
        return this;
    }

    public DataLoader includeDeletedArtifacts(boolean enabled) {
        OptionsUtil.setIncludeDeletedArtifacts((Options)this.getOptions(), (boolean)enabled);
        return this;
    }

    public DataLoader includeDeletedAttributes() {
        return this.includeDeletedAttributes(true);
    }

    public DataLoader includeDeletedAttributes(boolean enabled) {
        OptionsUtil.setIncludeDeletedAttributes((Options)this.getOptions(), (boolean)enabled);
        return this;
    }

    public DataLoader includeDeletedRelations() {
        return this.includeDeletedRelations(true);
    }

    public DataLoader includeDeletedRelations(boolean enabled) {
        OptionsUtil.setIncludeDeletedRelations((Options)this.getOptions(), (boolean)enabled);
        return this;
    }

    public boolean areDeletedArtifactsIncluded() {
        return OptionsUtil.areDeletedArtifactsIncluded((Options)this.getOptions());
    }

    public boolean areDeletedAttributesIncluded() {
        return OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions());
    }

    public boolean areDeletedRelationsIncluded() {
        return OptionsUtil.areDeletedRelationsIncluded((Options)this.getOptions());
    }

    public DataLoader fromTransaction(TransactionId transactionId) {
        OptionsUtil.setFromTransaction((Options)this.getOptions(), (TransactionId)transactionId);
        return this;
    }

    public DataLoader fromBranchView(ArtifactId viewId) {
        OptionsUtil.setFromBranchView((Options)this.getOptions(), (ArtifactId)viewId);
        return this;
    }

    public DataLoader fromHeadTransaction() {
        OptionsUtil.setHeadTransaction((Options)this.getOptions());
        return this;
    }

    public boolean isHeadTransaction() {
        return !OptionsUtil.isHistorical((Options)this.getOptions());
    }

    public LoadLevel getLoadLevel() {
        return OptionsUtil.getLoadLevel((Options)this.getOptions());
    }

    public DataLoader withLoadLevel(LoadLevel loadLevel) {
        OptionsUtil.setLoadLevel((Options)this.getOptions(), (LoadLevel)loadLevel);
        return this;
    }

    private DataLoader withArtifactIds(Collection<Integer> artifactIds) {
        this.loadExecutor = new LoadExecutor(this.sqlLoader, this.sqlLoader.getJdbcClient(), this.joinFactory, this.session, this.branchId, artifactIds);
        return this;
    }

    private DataLoader withArtifactGuids(Collection<String> artifactGuids) {
        this.loadExecutor = new UuidsLoadExecutor(this.sqlLoader, this.sqlLoader.getJdbcClient(), this.joinFactory, this.session, this.branchId, artifactGuids);
        return this;
    }

    public DataLoader withAttributeTypes(AttributeTypeId ... attributeType) throws OseeCoreException {
        return this.withAttributeTypes(Arrays.asList(attributeType));
    }

    public DataLoader withAttributeTypes(Collection<? extends AttributeTypeId> attributeTypes) throws OseeCoreException {
        this.attributeTypes.addAll(attributeTypes);
        return this;
    }

    public DataLoader withRelationTypes(IRelationType ... relationType) throws OseeCoreException {
        return this.withRelationTypes(Arrays.asList(relationType));
    }

    public DataLoader withRelationTypes(Collection<? extends IRelationType> relationTypes) throws OseeCoreException {
        this.relationTypes.addAll(relationTypes);
        return this;
    }

    public DataLoader withAttributeIds(int ... attributeIds) throws OseeCoreException {
        return this.withAttributeIds(this.toCollection(attributeIds));
    }

    public DataLoader withAttributeIds(Collection<Integer> attributeIds) throws OseeCoreException {
        this.attributeIds.addAll(attributeIds);
        return this;
    }

    public DataLoader withRelationIds(int ... relationIds) throws OseeCoreException {
        return this.withRelationIds(this.toCollection(relationIds));
    }

    public DataLoader withRelationIds(Collection<Integer> relationIds) throws OseeCoreException {
        this.relationIds.addAll(relationIds);
        return this;
    }

    private Collection<Integer> toCollection(int ... ids) {
        HashSet<Integer> toReturn = new HashSet<Integer>();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = nArray[n2];
            toReturn.add(id);
            ++n2;
        }
        return toReturn;
    }

    private <T> Collection<T> copy(Collection<T> source) {
        HashSet<T> toReturn = new HashSet<T>();
        for (T item : source) {
            toReturn.add(item);
        }
        return toReturn;
    }

    public void load(LoadDataHandler handler) throws OseeCoreException {
        this.load(null, handler);
    }

    public void load(HasCancellation cancellation, LoadDataHandler handler) throws OseeCoreException {
        Throwable saveException;
        block32: {
            long startTime = 0L;
            Options options = this.getOptions().clone();
            CriteriaOrcsLoad criteria = this.createCriteria();
            if (this.logger.isTraceEnabled()) {
                startTime = System.currentTimeMillis();
                this.logger.trace("%s [start] - [%s] [%s]", new Object[]{this.getClass().getSimpleName(), criteria, options});
            }
            this.determineLoadExecutor();
            saveException = null;
            try {
                try {
                    handler.onLoadStart();
                    this.loadExecutor.load(cancellation, handler, criteria, options);
                }
                catch (Exception ex) {
                    saveException = ex;
                    try {
                        try {
                            handler.onLoadEnd();
                        }
                        catch (OseeCoreException ex2) {
                            if (saveException == null) {
                                saveException = ex2;
                            }
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("%s [%s] - loaded [%s] [%s]", new Object[]{this.getClass().getSimpleName(), Lib.getElapseString((long)startTime), criteria, options});
                            }
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("%s [%s] - loaded [%s] [%s]", new Object[]{this.getClass().getSimpleName(), Lib.getElapseString((long)startTime), criteria, options});
                        }
                        throw throwable;
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("%s [%s] - loaded [%s] [%s]", new Object[]{this.getClass().getSimpleName(), Lib.getElapseString((long)startTime), criteria, options});
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                block34: {
                    try {
                        try {
                            handler.onLoadEnd();
                        }
                        catch (OseeCoreException ex) {
                            if (saveException == null) {
                                saveException = ex;
                            }
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("%s [%s] - loaded [%s] [%s]", new Object[]{this.getClass().getSimpleName(), Lib.getElapseString((long)startTime), criteria, options});
                            }
                            break block34;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("%s [%s] - loaded [%s] [%s]", new Object[]{this.getClass().getSimpleName(), Lib.getElapseString((long)startTime), criteria, options});
                        }
                        throw throwable2;
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("%s [%s] - loaded [%s] [%s]", new Object[]{this.getClass().getSimpleName(), Lib.getElapseString((long)startTime), criteria, options});
                    }
                }
                throw throwable;
            }
            try {
                try {
                    handler.onLoadEnd();
                }
                catch (OseeCoreException ex) {
                    if (saveException == null) {
                        saveException = ex;
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("%s [%s] - loaded [%s] [%s]", new Object[]{this.getClass().getSimpleName(), Lib.getElapseString((long)startTime), criteria, options});
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("%s [%s] - loaded [%s] [%s]", new Object[]{this.getClass().getSimpleName(), Lib.getElapseString((long)startTime), criteria, options});
                }
                throw throwable;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("%s [%s] - loaded [%s] [%s]", new Object[]{this.getClass().getSimpleName(), Lib.getElapseString((long)startTime), criteria, options});
            }
        }
        if (saveException != null) {
            OseeCoreException.wrapAndThrow((Throwable)saveException);
        }
    }

    private CriteriaOrcsLoad createCriteria() {
        CriteriaArtifact artifactCriteria = new CriteriaArtifact();
        CriteriaAttribute attributeCriteria = new CriteriaAttribute(this.copy(this.attributeIds), this.copy(this.attributeTypes));
        CriteriaRelation relationCriteria = new CriteriaRelation(this.copy(this.relationIds), this.copy(this.relationTypes));
        return new CriteriaOrcsLoad(artifactCriteria, attributeCriteria, relationCriteria);
    }

    private void determineLoadExecutor() throws OseeCoreException {
        if (this.loadExecutor == null) {
            throw new OseeArgumentException("Either artifacts ID or Query Context must be specified", new Object[0]);
        }
    }
}

