/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.HasLocalId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.RelationalConstants;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.DataFactory;
import org.eclipse.osee.orcs.core.ds.OrcsData;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.OrcsObjectFactory;

public class DataFactoryImpl
implements DataFactory {
    private final IdentityManager idFactory;
    private final OrcsObjectFactory objectFactory;
    private final ArtifactTypes artifactCache;

    public DataFactoryImpl(IdentityManager idFactory, OrcsObjectFactory objectFactory, ArtifactTypes artifactTypes) {
        this.idFactory = idFactory;
        this.objectFactory = objectFactory;
        this.artifactCache = artifactTypes;
    }

    public ArtifactData create(BranchId branch, IArtifactType token, String guid) throws OseeCoreException {
        return this.create(branch, token, guid, this.idFactory.getNextArtifactId());
    }

    public ArtifactData create(BranchId branchId, IArtifactType token, String guid, long artifactId) throws OseeCoreException {
        Conditions.checkNotNull((Object)branchId, (String)"branch");
        Conditions.checkExpressionFailOnTrue((boolean)this.artifactCache.isAbstract(token), (String)"Cannot create an instance of abstract type [%s]", (Object[])new Object[]{token});
        String guidToSet = this.idFactory.getUniqueGuid(guid);
        Conditions.checkExpressionFailOnTrue((!GUID.isValid((String)guidToSet) ? 1 : 0) != 0, (String)"Invalid guid [%s] during artifact creation [type: %s]", (Object[])new Object[]{guidToSet, token});
        VersionData version = this.objectFactory.createDefaultVersionData();
        version.setBranch(branchId);
        ModificationType modType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
        ArtifactData artifactData = this.objectFactory.createArtifactData(version, (int)artifactId, token, modType, guidToSet, ApplicabilityId.BASE);
        return artifactData;
    }

    public ArtifactData copy(BranchId destination, ArtifactData source) throws OseeCoreException {
        ArtifactData copy = this.objectFactory.createCopy(source);
        this.updateDataForCopy(destination, (OrcsData)copy);
        copy.setGuid(this.idFactory.getUniqueGuid(null));
        copy.setLocalId(Integer.valueOf(this.idFactory.getNextArtifactId()));
        return copy;
    }

    public AttributeData introduce(BranchId destination, AttributeData source) throws OseeCoreException {
        AttributeData newVersion = this.objectFactory.createCopy(source);
        newVersion.setUseBackingData(true);
        this.updateDataForIntroduce(destination, (OrcsData)newVersion);
        return newVersion;
    }

    public AttributeData create(ArtifactData parent, AttributeTypeId attributeType) throws OseeCoreException {
        VersionData version = this.objectFactory.createDefaultVersionData();
        version.setBranch(parent.getVersion().getBranch());
        ModificationType modType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
        return this.objectFactory.createAttributeData(version, this.idFactory.getNextAttributeId(), attributeType, modType, (Integer)parent.getLocalId(), ApplicabilityId.BASE);
    }

    public AttributeData copy(BranchId destination, AttributeData orcsData) throws OseeCoreException {
        AttributeData copy = this.objectFactory.createCopy(orcsData);
        this.updateDataForCopy(destination, (OrcsData)copy);
        copy.setLocalId(RelationalConstants.DEFAULT_ITEM_ID);
        return copy;
    }

    public ArtifactData introduce(BranchId destination, ArtifactData source) throws OseeCoreException {
        ArtifactData newVersion = this.objectFactory.createCopy(source);
        newVersion.setUseBackingData(true);
        this.updateDataForIntroduce(destination, (OrcsData)newVersion);
        return newVersion;
    }

    public RelationData createRelationData(RelationTypeId relationType, BranchId branch, HasLocalId<Integer> aArt, HasLocalId<Integer> bArt, String rationale) throws OseeCoreException {
        VersionData version = this.objectFactory.createDefaultVersionData();
        version.setBranch(branch);
        ModificationType modType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
        return this.objectFactory.createRelationData(version, (Integer)this.idFactory.getNextRelationId(), relationType, modType, (int)((Integer)aArt.getLocalId()), (int)((Integer)bArt.getLocalId()), rationale, ApplicabilityId.BASE);
    }

    public TupleData createTuple2Data(Long tupleTypeId, BranchId branch, Long e1, Long e2) {
        VersionData version = this.objectFactory.createDefaultVersionData();
        TupleData tupleData = this.objectFactory.createTuple2Data(version, branch, tupleTypeId, e1, e2);
        return tupleData;
    }

    public TupleData createTuple3Data(Long tupleTypeId, BranchId branch, Long e1, Long e2, Long e3) {
        VersionData version = this.objectFactory.createDefaultVersionData();
        TupleData tupleData = this.objectFactory.createTuple3Data(version, branch, tupleTypeId, e1, e2, e3);
        return tupleData;
    }

    public TupleData createTuple4Data(Long tupleTypeId, BranchId branch, Long e1, Long e2, Long e3, Long e4) {
        VersionData version = this.objectFactory.createDefaultVersionData();
        TupleData tupleData = this.objectFactory.createTuple4Data(version, branch, tupleTypeId, e1, e2, e3, e4);
        return tupleData;
    }

    public RelationData introduce(BranchId destination, RelationData source) {
        RelationData newVersion = this.objectFactory.createCopy(source);
        newVersion.setUseBackingData(true);
        this.updateDataForIntroduce(destination, (OrcsData)newVersion);
        return newVersion;
    }

    public ArtifactData clone(ArtifactData source) {
        return this.objectFactory.createCopy(source);
    }

    public AttributeData clone(AttributeData source) throws OseeCoreException {
        return this.objectFactory.createCopy(source);
    }

    public RelationData clone(RelationData source) throws OseeCoreException {
        return this.objectFactory.createCopy(source);
    }

    private void updateDataForCopy(BranchId destination, OrcsData data) throws OseeCoreException {
        VersionData version = data.getVersion();
        version.setBranch(destination);
        version.setTransactionId(TransactionId.SENTINEL);
        version.setStripeId(TransactionId.SENTINEL);
        version.setHistorical(false);
        version.setGammaId(-1L);
        data.setModType(ModificationType.NEW);
    }

    private void updateDataForIntroduce(BranchId destination, OrcsData data) throws OseeCoreException {
        VersionData version = data.getVersion();
        version.setBranch(destination);
        version.setHistorical(false);
        version.setTransactionId(TransactionId.SENTINEL);
    }
}

