/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader;

import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.DataProxyFactory;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.loader.DataProxyFactoryProvider;
import org.eclipse.osee.orcs.db.internal.loader.ProxyDataFactory;

public class AttributeDataProxyFactory
implements ProxyDataFactory {
    private final DataProxyFactoryProvider proxyProvider;
    private final AttributeTypes attributeTypeCache;
    private final JdbcClient jdbcClient;

    public AttributeDataProxyFactory(DataProxyFactoryProvider proxyProvider, JdbcClient jdbcClient, AttributeTypes attributeTypes) {
        this.proxyProvider = proxyProvider;
        this.attributeTypeCache = attributeTypes;
        this.jdbcClient = jdbcClient;
    }

    @Override
    public DataProxy createProxy(long typeUuid, Object value, String uri) throws OseeCoreException {
        AttributeTypeId attributeType = (AttributeTypeId)this.attributeTypeCache.get(Long.valueOf(typeUuid));
        Conditions.checkNotNull((Object)attributeType, (String)"AttributeType", (String)"Unable to find attributeType for [%s]", (Object[])new Object[]{typeUuid});
        String dataProxyFactoryId = this.attributeTypeCache.getAttributeProviderId(attributeType);
        if (dataProxyFactoryId.contains(".")) {
            dataProxyFactoryId = Lib.getExtension((String)dataProxyFactoryId);
        }
        DataProxyFactory factory = this.proxyProvider.getFactory(dataProxyFactoryId);
        Conditions.checkNotNull((Object)factory, (String)"DataProxyFactory", (String)"Unable to find data proxy factory for [%s]", (Object[])new Object[]{dataProxyFactoryId});
        Object checkedValue = this.intern(attributeType, value);
        DataProxy proxy = factory.createInstance(dataProxyFactoryId);
        proxy.setData(new Object[]{checkedValue, uri});
        return proxy;
    }

    private Object intern(AttributeTypeId attributeType, Object original) throws OseeCoreException {
        Object value = original;
        if (this.attributeTypeCache.isEnumerated(attributeType) && value instanceof String) {
            value = Strings.intern((String)((String)value));
        }
        return value;
    }

    @Override
    public DataProxy createProxy(long typeUuid, Object ... data) throws OseeCoreException {
        Conditions.checkNotNull((Object)data, (String)"data");
        Conditions.checkExpressionFailOnTrue((data.length < 2 ? 1 : 0) != 0, (String)"Data must have at least [2] elements - size was [%s]", (Object[])new Object[]{data.length});
        Object value = data[0];
        String uri = (String)data[1];
        return this.createProxy(typeUuid, value, uri);
    }
}

