/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSaxHandler;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.jdbc.SQL3DataType;
import org.eclipse.osee.orcs.db.internal.exchange.handler.MetaData;
import org.xml.sax.Attributes;

public class MetaDataSaxHandler
extends AbstractSaxHandler {
    private final Map<String, MetaData> importMetadataMap;
    private final Map<String, MetaData> targetMetadataMap;
    private final JdbcClient service;
    private MetaData currentMetadata;

    public MetaDataSaxHandler(JdbcClient service) {
        this.service = service;
        this.importMetadataMap = new HashMap<String, MetaData>();
        this.targetMetadataMap = new HashMap<String, MetaData>();
    }

    public MetaData getMetadata(String source) {
        return this.targetMetadataMap.get(source);
    }

    public void startElementFound(String uri, String localName, String name, Attributes attributes) {
        if (localName.equalsIgnoreCase("metadata")) {
            this.importMetadataMap.clear();
        } else if (localName.equalsIgnoreCase("table")) {
            String tableName = attributes.getValue("name");
            if (Strings.isValid((String)tableName)) {
                this.currentMetadata = new MetaData(tableName);
                this.importMetadataMap.put(tableName, this.currentMetadata);
            } else {
                this.currentMetadata = null;
            }
        } else if (localName.equalsIgnoreCase("column")) {
            String columnName = attributes.getValue("id");
            String typeName = attributes.getValue("type");
            SQL3DataType sql3DataType = SQL3DataType.valueOf((String)typeName);
            this.currentMetadata.addColumn(columnName, sql3DataType);
        }
    }

    public void endElementFound(String uri, String localName, String name) throws Exception {
        if (localName.equalsIgnoreCase("table")) {
            this.currentMetadata = null;
        }
    }

    public void checkAndLoadTargetDbMetadata() throws OseeCoreException, SQLException {
        Map<String, MetaData> targetTables = this.getTargetDbMetadata();
        StringBuffer errorMessage = new StringBuffer();
        for (String tableName : targetTables.keySet()) {
            MetaData sourceMeta = this.importMetadataMap.get(tableName);
            MetaData destinationMeta = targetTables.get(tableName);
            Collection<String> sourceColumns = sourceMeta.getColumnNames();
            for (String destinationColumn : destinationMeta.getColumnNames()) {
                if (sourceColumns.contains(destinationColumn)) continue;
                errorMessage.append(String.format("Target column not found in source database.\nTable:[%s] - [%s not in (%s)]\n", tableName, destinationColumn, sourceColumns));
            }
        }
        if (errorMessage.length() > 0) {
            throw new OseeCoreException(errorMessage.toString(), new Object[0]);
        }
        this.targetMetadataMap.putAll(targetTables);
    }

    private Map<String, MetaData> getTargetDbMetadata() throws SQLException, OseeCoreException {
        HashMap<String, MetaData> targetDbMetadata = new HashMap<String, MetaData>();
        try (JdbcConnection connection = this.service.getConnection();){
            DatabaseMetaData dbMetaData = connection.getMetaData();
            for (String sourceTables : this.importMetadataMap.keySet()) {
                this.processMetaData(targetDbMetadata, dbMetaData, sourceTables);
            }
        }
        return targetDbMetadata;
    }

    private void processMetaData(Map<String, MetaData> targetDbMetadata, DatabaseMetaData dbMetaData, String targetTable) throws SQLException, OseeCoreException {
        try (ResultSet resultSet = null;){
            resultSet = dbMetaData.getTables(null, null, null, new String[]{"TABLE"});
            if (resultSet != null) {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    String schemaName = resultSet.getString("TABLE_SCHEM");
                    if (!targetTable.equalsIgnoreCase(tableName)) continue;
                    String name = tableName.toLowerCase();
                    MetaData currentMetadata = new MetaData(name);
                    targetDbMetadata.put(name, currentMetadata);
                    this.processColumnMetaData(currentMetadata, dbMetaData, schemaName, tableName);
                }
            }
        }
    }

    private void processColumnMetaData(MetaData currentMetadata, DatabaseMetaData dbMetaData, String schema, String tableName) throws SQLException, OseeCoreException {
        try (ResultSet resultSet = null;){
            try {
                resultSet = dbMetaData.getColumns(null, schema, tableName, null);
            }
            catch (SQLException sQLException) {
                resultSet = dbMetaData.getColumns(null, null, tableName, null);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    String columnId = resultSet.getString("COLUMN_NAME").toLowerCase();
                    int dataType = resultSet.getInt("DATA_TYPE");
                    if (JdbcDbType.getDbType((DatabaseMetaData)dbMetaData).equals((Object)JdbcDbType.foxpro) && dataType == 1) {
                        dataType = 12;
                    }
                    currentMetadata.addColumn(columnId, SQL3DataType.get((int)dataType));
                }
            }
        }
    }
}

