/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.exception.OseeDataStoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.ImportOptions;
import org.eclipse.osee.orcs.db.internal.exchange.handler.BaseDbSaxHandler;
import org.eclipse.osee.orcs.db.internal.exchange.handler.BranchData;
import org.eclipse.osee.orcs.db.internal.exchange.handler.DataToSql;

public class BranchDataSaxHandler
extends BaseDbSaxHandler {
    private final Map<Long, BranchData> idToImportFileBranchData = new HashMap<Long, BranchData>();
    private JdbcConnection connection = null;

    public static BranchDataSaxHandler createWithCacheAll(Log logger, JdbcClient service) {
        return new BranchDataSaxHandler(logger, service, true, 0);
    }

    public static BranchDataSaxHandler newLimitedCacheBranchDataSaxHandler(Log logger, JdbcClient service, int cacheLimit) {
        return new BranchDataSaxHandler(logger, service, false, cacheLimit);
    }

    private BranchDataSaxHandler(Log logger, JdbcClient service, boolean isCacheAll, int cacheLimit) {
        super(logger, service, isCacheAll, cacheLimit);
    }

    @Override
    protected void processData(Map<String, String> dataMap) throws OseeArgumentException {
        BranchData branchData = new BranchData();
        for (String columnName : this.getMetaData().getColumnNames()) {
            String value = dataMap.get(columnName);
            branchData.setData(columnName, this.toObject(columnName, value));
        }
        this.idToImportFileBranchData.put(branchData.getId(), branchData);
    }

    private Object toObject(String key, String value) throws OseeArgumentException {
        Object toReturn = null;
        if (Strings.isValid((String)value)) {
            Class<?> clazz = this.getMetaData().toClass(key);
            toReturn = DataToSql.stringToObject(clazz, key, value);
        } else {
            toReturn = this.getMetaData().toDataType(key);
        }
        return toReturn;
    }

    public boolean areAvailable(long ... branchUuids) {
        boolean toReturn = false;
        if (branchUuids != null && branchUuids.length > 0) {
            HashSet<Long> toCheck = new HashSet<Long>();
            long[] lArray = branchUuids;
            int n = branchUuids.length;
            int n2 = 0;
            while (n2 < n) {
                long entry = lArray[n2];
                toCheck.add(entry);
                ++n2;
            }
            toReturn = this.idToImportFileBranchData.keySet().containsAll(toCheck);
        }
        return toReturn;
    }

    public Collection<BranchData> getAllBranchDataFromImportFile() {
        return this.idToImportFileBranchData.values();
    }

    private List<BranchData> getSelectedBranchesToImport(long ... branchesToImport) {
        ArrayList<BranchData> toReturn = new ArrayList<BranchData>();
        if (branchesToImport != null && branchesToImport.length > 0) {
            long[] lArray = branchesToImport;
            int n = branchesToImport.length;
            int n2 = 0;
            while (n2 < n) {
                long branchUuid = lArray[n2];
                BranchData data = this.idToImportFileBranchData.get(branchUuid);
                if (data != null) {
                    toReturn.add(data);
                }
                ++n2;
            }
        } else {
            toReturn.addAll(this.idToImportFileBranchData.values());
        }
        return toReturn;
    }

    private void checkSelectedBranches(long ... branchesToImport) throws OseeDataStoreException {
        if (branchesToImport != null && branchesToImport.length > 0 && !this.areAvailable(branchesToImport)) {
            throw new OseeDataStoreException("Branches not found in import file:\n\t\t- selected to import: [%s]\n\t\t- in import file: [%s]", new Object[]{branchesToImport, this.getAllBranchDataFromImportFile()});
        }
    }

    public long[] store(JdbcConnection connection, boolean writeToDb, long ... branchesToImport) throws OseeCoreException {
        this.checkSelectedBranches(branchesToImport);
        Collection<BranchData> branchesToStore = this.getSelectedBranchesToImport(branchesToImport);
        branchesToStore = this.checkTargetDbBranches(connection, branchesToStore);
        long[] toReturn = new long[branchesToStore.size()];
        int index = 0;
        for (BranchData branchData : branchesToStore) {
            if (!this.getOptions().getBoolean(ImportOptions.CLEAN_BEFORE_IMPORT.name()) && CoreBranches.SYSTEM_ROOT.equals(Long.valueOf(branchData.getId()))) continue;
            toReturn[index] = branchData.getId();
            if (this.getOptions().getBoolean(ImportOptions.ALL_AS_ROOT_BRANCHES.name())) {
                branchData.setParentBranchId(1L);
                branchData.setBranchType(BranchType.BASELINE);
            } else {
                branchData.setParentBranchId(this.translateLongId("parent_branch_id", branchData.getParentBranchId()));
            }
            branchData.setBranchId(this.translateLongId("branch_id", branchData.getId()));
            branchData.setAssociatedBranchId(this.translateIntId("associated_art_id", branchData.getAssociatedArtId()));
            Object[] data = branchData.toArray(this.getMetaData());
            if (data != null) {
                this.addData(data);
            }
            ++index;
        }
        if (writeToDb) {
            super.store(connection);
        }
        return toReturn;
    }

    public void updateBaselineAndParentTransactionId(long[] branchesStored) throws OseeCoreException {
        List<BranchData> branches = this.getSelectedBranchesToImport(branchesStored);
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (BranchData branchData : branches) {
            int baselineTransactionId;
            long branchUuid = branchData.getId();
            int parentTransactionId = this.translateIntId("transaction_id", branchData.getParentTransactionId());
            if (parentTransactionId == 0) {
                parentTransactionId = 1;
            }
            if ((baselineTransactionId = this.translateIntId("transaction_id", branchData.getBaselineTransactionId())) == 0) {
                baselineTransactionId = 1;
            }
            data.add(new Object[]{parentTransactionId, baselineTransactionId, branchUuid});
        }
        if (!data.isEmpty()) {
            String query = "update osee_branch set parent_transaction_id = ?, baseline_transaction_id = ? where branch_id = ?";
            int updateCount = this.getDatabaseService().runBatchUpdate(query, data);
            this.getLogger().info("Updated [%s] baseline and parent transaction id info on branches [%s]", new Object[]{updateCount, Arrays.toString(branchesStored)});
        } else {
            this.getLogger().info("No branches found to update baseline and parent txs: branches - [%s] - skipping", new Object[]{Arrays.toString(branchesStored)});
        }
    }

    private long translateLongId(String id, long originalValue) throws OseeCoreException {
        Long original = new Long(originalValue);
        Long newValue = (Long)this.getTranslator().translate(id, original);
        return newValue.intValue();
    }

    private int translateIntId(String id, int originalValue) throws OseeCoreException {
        Long original = new Long(originalValue);
        Long newValue = (Long)this.getTranslator().translate(id, original);
        return newValue.intValue();
    }

    private Collection<BranchData> checkTargetDbBranches(JdbcConnection connection, Collection<BranchData> selectedBranches) throws OseeCoreException {
        HashMap<Long, BranchData> idToBranchData = new HashMap<Long, BranchData>();
        for (BranchData data : selectedBranches) {
            idToBranchData.put(data.getId(), data);
        }
        try (JdbcStatement chStmt = this.getDatabaseService().getStatement(connection);){
            chStmt.runPreparedQuery("select * from osee_branch", new Object[0]);
            while (chStmt.next()) {
                Long branchUuid = chStmt.getLong("branch_id");
                BranchData branchData = (BranchData)idToBranchData.get(branchUuid);
                if (branchData == null) continue;
                this.getTranslator().checkIdMapping("branch_id", branchData.getId(), branchUuid);
                idToBranchData.remove(branchUuid);
            }
        }
        return idToBranchData.values();
    }

    @Override
    public void clearDataTable() throws OseeCoreException {
        this.getDatabaseService().runPreparedUpdate(this.getConnection(), String.format("DELETE FROM %s where NOT branch_type = " + BranchType.SYSTEM_ROOT.getValue(), this.getMetaData().getTableName()), new Object[0]);
    }

    public void setConnection(JdbcConnection connection) {
        this.connection = connection;
    }

    public JdbcConnection getConnection() {
        return this.connection;
    }

    @Override
    public void reset() {
        super.reset();
        this.setConnection(null);
    }

    @Override
    public void store() throws OseeCoreException {
        super.store(this.getConnection());
    }
}

