/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.TranslationManager;
import org.eclipse.osee.orcs.db.internal.exchange.handler.BaseExportImportSaxHandler;
import org.eclipse.osee.orcs.db.internal.exchange.handler.MetaData;

public abstract class BaseDbSaxHandler
extends BaseExportImportSaxHandler {
    private final List<Object[]> data;
    private final int cacheLimit;
    private final boolean isCacheAll;
    private MetaData metadata;
    private TranslationManager translator;
    private PropertyStore options;
    private final JdbcClient service;
    private final Log logger;

    protected BaseDbSaxHandler(Log logger, JdbcClient service, boolean isCacheAll, int cacheLimit) {
        if (cacheLimit < 0) {
            throw new IllegalArgumentException(String.format("Cache limit cannot be less than zero - cacheLimit=[%d]", cacheLimit));
        }
        this.logger = logger;
        this.service = service;
        this.options = new PropertyStore();
        this.translator = null;
        this.metadata = null;
        this.isCacheAll = isCacheAll;
        this.cacheLimit = cacheLimit;
        this.data = new ArrayList<Object[]>();
    }

    protected Log getLogger() {
        return this.logger;
    }

    public void setOptions(PropertyStore options) {
        if (options != null) {
            this.options = options;
        }
    }

    protected PropertyStore getOptions() {
        return this.options;
    }

    public void setMetaData(MetaData metadata) {
        this.metadata = metadata;
    }

    public void setTranslator(TranslationManager translator) {
        this.translator = translator;
    }

    protected MetaData getMetaData() {
        return this.metadata;
    }

    protected TranslationManager getTranslator() {
        return this.translator;
    }

    public boolean isStorageNeeded() {
        return !this.isCacheAll && this.data.size() > this.cacheLimit;
    }

    protected void addData(Object[] objects) {
        this.data.add(objects);
    }

    public void store() throws OseeCoreException {
        this.store(null);
    }

    public void store(JdbcConnection connection) throws OseeCoreException {
        if (!this.data.isEmpty()) {
            this.getDatabaseService().runBatchUpdate(connection, this.getMetaData().getQuery(), this.data);
            this.data.clear();
        }
    }

    private boolean isTruncateSupported() throws OseeCoreException {
        boolean isTruncateSupported;
        block18: {
            isTruncateSupported = false;
            try (JdbcConnection connection = this.service.getConnection();){
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet resultSet = null;
                try {
                    try {
                        resultSet = metaData.getTablePrivileges(null, null, this.getMetaData().getTableName().toUpperCase());
                        while (resultSet.next()) {
                            String value = resultSet.getString("PRIVILEGE");
                            if (!"TRUNCATE".equalsIgnoreCase(value)) continue;
                            isTruncateSupported = true;
                            break;
                        }
                    }
                    catch (SQLException ex1) {
                        this.logger.info((Throwable)ex1, "Error determining truncate support", new Object[0]);
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return isTruncateSupported;
    }

    public void clearDataTable() throws OseeCoreException {
        String cmd = this.isTruncateSupported() ? "TRUNCATE TABLE" : "DELETE FROM";
        String deleteSql = String.format("%s %s", cmd, this.getMetaData().getTableName());
        try {
            this.getDatabaseService().runPreparedUpdate(deleteSql, new Object[0]);
        }
        catch (OseeCoreException ex) {
            this.logger.info((Throwable)ex, "Error clearing: %s", new Object[]{deleteSql});
            throw ex;
        }
    }

    protected JdbcClient getDatabaseService() {
        return this.service;
    }

    public void reset() {
        this.translator = null;
        this.options = null;
        this.metadata = null;
        this.data.clear();
    }
}

