/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;

public class SavePointManager {
    private static final String SAVE_POINT_PREFIX = "save.point.";
    private static final String LOAD_SAVE_POINT_ID = "load.save.points";
    private static final String INSERT_INTO_IMPORT_SAVE_POINT = "INSERT INTO osee_import_save_point (import_id, save_point_name, status, state_error) VALUES (?, ?, ?, ?)";
    private static final String QUERY_SAVE_POINTS_FROM_IMPORT_MAP = "SELECT save_point_name from osee_import_save_point oisp, osee_import_source ois WHERE ois.import_id = oisp.import_id AND oisp.status = 1 AND ois.db_source_guid = ? AND ois.source_export_date = ?";
    private final Map<String, SavePoint> savePoints = new LinkedHashMap<String, SavePoint>();
    private final JdbcClient jdbcClient;
    private String currentSavePoint;

    public SavePointManager(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    private JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    public void storeSavePoints(JdbcConnection connection, int importIdIndex) throws OseeCoreException {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (SavePoint savePoint : this.savePoints.values()) {
            int status = 1;
            String comment = "";
            if (savePoint.hasErrors()) {
                status = -1;
                StringBuilder builder = new StringBuilder();
                for (Throwable ex : savePoint.getErrors()) {
                    builder.append(Lib.exceptionToString((Throwable)ex).replaceAll("\n", " "));
                }
                comment = builder.length() < 4000 ? builder.toString() : builder.substring(0, 4000);
            }
            data.add(new Object[]{importIdIndex, savePoint.getName(), status, comment});
        }
        this.getJdbcClient().runBatchUpdate(connection, INSERT_INTO_IMPORT_SAVE_POINT, data);
    }

    public void loadSavePoints(String sourceDatabaseId, Date sourceExportDate) throws OseeCoreException {
        this.setCurrentSetPointId(LOAD_SAVE_POINT_ID);
        this.getJdbcClient().runQuery(stmt -> {
            String key = stmt.getString("save_point_name");
            this.savePoints.put(key, new SavePoint(key));
        }, QUERY_SAVE_POINTS_FROM_IMPORT_MAP, new Object[]{sourceDatabaseId, new Timestamp(sourceExportDate.getTime())});
        this.addCurrentSavePointToProcessed();
    }

    public String getCurrentSetPointId() {
        return this.currentSavePoint;
    }

    public void setCurrentSetPointId(String savePointId) {
        this.currentSavePoint = savePointId;
    }

    public void clear() {
        this.savePoints.clear();
    }

    public String asSavePointName(String sourceName) {
        return SAVE_POINT_PREFIX + sourceName;
    }

    public boolean isCurrentInProcessed() {
        return this.doesSavePointExist(this.getCurrentSetPointId());
    }

    private boolean doesSavePointExist(String sourceName) {
        return this.savePoints.containsKey(this.asSavePointName(sourceName));
    }

    public void addCurrentSavePointToProcessed() {
        this.addSavePoint(this.getCurrentSetPointId());
    }

    private void addSavePoint(String sourceName) {
        String key = this.asSavePointName(sourceName);
        SavePoint point = this.savePoints.get(key);
        if (point == null) {
            point = new SavePoint(key);
            this.savePoints.put(key, point);
        }
    }

    public void reportError(Throwable ex) {
        this.reportError(this.getCurrentSetPointId(), ex);
    }

    private void reportError(String sourceName, Throwable ex) {
        String key = this.asSavePointName(sourceName);
        SavePoint point = this.savePoints.get(key);
        if (point == null) {
            point = new SavePoint(key);
            this.savePoints.put(key, point);
        }
        point.addError(ex);
    }

    private final class SavePoint {
        private final String savePointName;
        private List<Throwable> errors;

        public SavePoint(String name) {
            this.savePointName = name;
            this.errors = null;
        }

        public String getName() {
            return this.savePointName;
        }

        public void addError(Throwable ex) {
            if (this.errors == null) {
                this.errors = new ArrayList<Throwable>();
            }
            if (!this.errors.contains(ex)) {
                this.errors.add(ex);
            }
        }

        public List<Throwable> getErrors() {
            if (this.errors == null) {
                return Collections.emptyList();
            }
            return this.errors;
        }

        public boolean hasErrors() {
            return this.errors != null;
        }
    }
}

