/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.ForeignKeyReader;
import org.eclipse.osee.orcs.db.internal.exchange.PrimaryKeyCollector;
import org.eclipse.osee.orcs.db.internal.exchange.handler.IExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.transform.ExchangeDataProcessor;
import org.xml.sax.ContentHandler;

public class ReferentialIntegrityConstraint {
    private final List<IExportItem> primaryItems = new ArrayList<IExportItem>();
    private final List<String> primaryKeys = new ArrayList<String>();
    private final List<IExportItem> foreignItems = new ArrayList<IExportItem>();
    private final List<String[]> foreignKeys = new ArrayList<String[]>();
    private PrimaryKeyCollector collector;
    private Iterator<String> primaryKeyIterator;
    private Iterator<String[]> foreignKeyIterator;

    public ReferentialIntegrityConstraint(IExportItem primaryItem, String primaryKey) {
        this.addPrimaryKey(primaryItem, primaryKey);
    }

    public void addPrimaryKey(IExportItem primaryItem, String primaryKey) {
        this.primaryItems.add(primaryItem);
        this.primaryKeys.add(primaryKey);
    }

    public void addForeignKey(IExportItem foreignItem, String ... foreignKeys) {
        this.foreignItems.add(foreignItem);
        this.foreignKeys.add(foreignKeys);
    }

    public List<IExportItem> getPrimaryItems() {
        this.primaryKeyIterator = this.primaryKeys.iterator();
        return this.primaryItems;
    }

    public String getPrimaryKeyListing() {
        ArrayList<String> primaryKeys = new ArrayList<String>(this.primaryItems.size());
        for (IExportItem primaryTable : this.getPrimaryItems()) {
            primaryKeys.add(primaryTable + "." + this.getPrimaryKey());
        }
        return Collections.toString((String)",", primaryKeys);
    }

    public String getPrimaryKey() {
        return this.primaryKeyIterator.next();
    }

    public List<IExportItem> getForeignItems() {
        this.foreignKeyIterator = this.foreignKeys.iterator();
        return this.foreignItems;
    }

    public String[] getForeignKeys() {
        return this.foreignKeyIterator.next();
    }

    public HashCollection<String, Long> getMissingPrimaryKeys() {
        return this.collector.getMissingPrimaryKeys();
    }

    public Set<Long> getUnreferencedPrimaryKeys() {
        return this.collector.getUnreferencedPrimaryKeys();
    }

    public void checkConstraint(Log logger, JdbcClient jdbcClient, ExchangeDataProcessor processor) throws OseeCoreException {
        this.collector = new PrimaryKeyCollector(logger, jdbcClient);
        for (IExportItem primaryTable : this.getPrimaryItems()) {
            this.collector.setPrimaryKey(this.getPrimaryKey());
            processor.parse(primaryTable, (ContentHandler)((Object)this.collector));
        }
        for (IExportItem foreignTable : this.getForeignItems()) {
            ForeignKeyReader foreignKeyReader = new ForeignKeyReader(logger, jdbcClient, this.collector, foreignTable, this.getForeignKeys());
            processor.parse(foreignTable, (ContentHandler)((Object)foreignKeyReader));
        }
    }
}

