/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;

public class IdTranslator {
    private static final String INSERT_INTO_IMPORT_INDEX_MAP = "INSERT INTO osee_import_index_map (sequence_id, original_id, mapped_id) VALUES (?, ?, ?)";
    private static final String SELECT_IDS_BY_DB_SOURCE_AND_SEQ_NAME = "SELECT original_id, mapped_id FROM osee_import_source ois, osee_import_map oim, osee_import_index_map oiim WHERE ois.import_id = oim.import_id AND oim.sequence_id = oiim.sequence_id AND oiim.sequence_id = oiim.sequence_id AND ois.db_source_guid = ?  AND oim.sequence_name = ?";
    private final String sequenceName;
    private final Map<Long, Long> originalToMapped;
    private final List<Long> newIds;
    private final Set<String> aliases;
    private final JdbcClient jdbcClient;

    IdTranslator(JdbcClient jdbcClient, String sequenceName, String ... aliases) {
        this.jdbcClient = jdbcClient;
        this.sequenceName = sequenceName;
        this.originalToMapped = new HashMap<Long, Long>();
        this.newIds = new ArrayList<Long>();
        this.aliases = new HashSet<String>();
        if (aliases != null && aliases.length > 0) {
            String[] stringArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                this.aliases.add(alias.toLowerCase());
                ++n2;
            }
        }
    }

    public boolean hasAliases() {
        return this.aliases.size() > 0;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Object getId(Object original) throws OseeCoreException {
        Long newVersion;
        Long originalLong = null;
        if (original instanceof Double) {
            originalLong = ((Double)original).longValue();
        } else if (original instanceof Integer) {
            originalLong = ((Integer)original).longValue();
        } else if (original instanceof Long) {
            originalLong = (long)((Long)original);
        } else if (original instanceof BigInteger) {
            originalLong = ((BigInteger)original).longValue();
        } else if (original instanceof BigDecimal) {
            originalLong = ((BigDecimal)original).longValue();
        } else {
            throw new OseeCoreException("Undefined Type [%s]", new Object[]{original != null ? original.getClass().getSimpleName() : original});
        }
        Number toReturn = newVersion = this.transalateId(originalLong);
        if (original instanceof Double) {
            toReturn = (double)newVersion;
        } else if (original instanceof Integer) {
            toReturn = newVersion.intValue();
        } else if (original instanceof Long) {
            toReturn = newVersion;
        } else if (original instanceof BigInteger) {
            toReturn = BigInteger.valueOf(newVersion);
        } else if (original instanceof BigDecimal) {
            toReturn = BigDecimal.valueOf(newVersion);
        } else {
            throw new OseeCoreException("Undefined Type [%s]", new Object[]{original.getClass().getSimpleName()});
        }
        return toReturn;
    }

    private Long transalateId(Long original) throws OseeCoreException {
        Long newVersion = null;
        if (original <= 0L) {
            newVersion = original;
        } else {
            newVersion = this.originalToMapped.get(original);
            if (newVersion == null) {
                newVersion = this.jdbcClient.getNextSequence(this.getSequenceName(), true);
                this.addToCache(original, newVersion);
            }
        }
        return newVersion;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void addToCache(Long original, Long newValue) {
        this.originalToMapped.put(original, newValue);
        this.newIds.add(original);
    }

    public Long getFromCache(Long original) {
        Long newVersion = null;
        newVersion = original <= 0L ? original : this.originalToMapped.get(original);
        return newVersion;
    }

    public void load(String sourceDatabaseId) throws OseeCoreException {
        this.originalToMapped.clear();
        this.jdbcClient.runQuery(stmt -> {
            Long l = this.originalToMapped.put(stmt.getLong("original_id"), stmt.getLong("mapped_id"));
        }, SELECT_IDS_BY_DB_SOURCE_AND_SEQ_NAME, new Object[]{sourceDatabaseId, this.getSequenceName()});
    }

    public boolean hasItemsToStore() {
        return !this.newIds.isEmpty();
    }

    public void store(JdbcConnection connection, int sequenceId) throws OseeCoreException {
        if (this.hasItemsToStore()) {
            ArrayList<Object[]> data = new ArrayList<Object[]>();
            for (Long original : this.newIds) {
                Long mapped = this.originalToMapped.get(original);
                data.add(new Object[]{sequenceId, original, mapped});
            }
            this.jdbcClient.runBatchUpdate(connection, INSERT_INTO_IMPORT_INDEX_MAP, data);
        }
    }
}

