/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.console;

import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.console.AbstractDatastoreConsoleCommand;
import org.eclipse.osee.orcs.db.internal.sql.join.ExportImportJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class FixDuplicateAttributesCommand
extends AbstractDatastoreConsoleCommand {
    private OrcsApi orcsApi;
    private SqlJoinFactory joinFactory;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setSqlJoinFactory(SqlJoinFactory joinFactory) {
        this.joinFactory = joinFactory;
    }

    public String getName() {
        return "db_fix_duplicate_attributes";
    }

    public String getDescription() {
        return "Detect and fix duplicate attributes";
    }

    public String getUsage() {
        return "No Parameters";
    }

    public Callable<?> createCallable(Console console, ConsoleParameters params) {
        return new DuplicateAttributesDatabaseTxCallable(this.getLogger(), this.getSession(), this.getJdbcClient(), console);
    }

    private final class DuplicateAttributesDatabaseTxCallable
    extends AbstractDatastoreTxCallable<Object> {
        private static final String SELECT_ATTRIBUTES = "select att1.gamma_id as gamma1, att2.gamma_id as gamma2 from osee_join_id oji, osee_attribute att1, osee_attribute att2 where oji.query_id = ? AND oji.id = att1.attr_type_id and att1.art_id = att2.art_id and att1.attr_type_id = att2.attr_type_id and att1.attr_id <> att2.attr_id";
        private static final String SELECT_DUPLICATES = "select txs1.branch_id, txs1.gamma_id as gamma1, txs2.gamma_id as gamma2  from osee_join_export_import idj, osee_txs txs1, osee_txs txs2 where idj.query_id = ? and idj.id1 = txs1.gamma_id and idj.id2 = txs2.gamma_id and txs1.branch_id = txs2.branch_id and txs1.tx_current = ? and  txs2.tx_current = ?";
        private final Console console;

        public DuplicateAttributesDatabaseTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, Console console) {
            super(logger, session, jdbcClient);
            this.console = console;
        }

        @Override
        protected Object handleTxWork(JdbcConnection connection) throws OseeCoreException {
            ExportImportJoinQuery gammaJoin = FixDuplicateAttributesCommand.this.joinFactory.createExportImportJoinQuery();
            try {
                try {
                    this.selectAttributes(gammaJoin, connection);
                    gammaJoin.store(connection);
                    this.selectDuplicates(gammaJoin, connection);
                }
                catch (Exception ex) {
                    this.console.write((Throwable)ex);
                    this.getLogger().error((Throwable)ex, "Error fixing duplicate attributes", new Object[0]);
                    gammaJoin.delete(connection);
                }
            }
            finally {
                gammaJoin.delete(connection);
            }
            return null;
        }

        private void selectAttributes(ExportImportJoinQuery gammaJoin, JdbcConnection connection) throws OseeCoreException {
            IdJoinQuery typeJoin = FixDuplicateAttributesCommand.this.joinFactory.createIdJoinQuery();
            this.populateAttributeTypeJoin(typeJoin);
            JdbcStatement chStmt = this.getJdbcClient().getStatement(connection);
            try {
                chStmt.runPreparedQuery(10000, SELECT_ATTRIBUTES, new Object[]{typeJoin.getQueryId()});
                while (chStmt.next()) {
                    gammaJoin.add(chStmt.getLong("gamma1"), chStmt.getLong("gamma2"));
                }
            }
            finally {
                chStmt.close();
                typeJoin.delete(connection);
            }
        }

        private void selectDuplicates(ExportImportJoinQuery gammaJoin, JdbcConnection connection) throws OseeCoreException {
            try (JdbcStatement chStmt = this.getJdbcClient().getStatement(connection);){
                chStmt.runPreparedQuery(SELECT_DUPLICATES, new Object[]{gammaJoin.getQueryId(), TxChange.CURRENT.getValue(), TxChange.CURRENT.getValue()});
                while (chStmt.next()) {
                    this.console.writeln("branch: " + chStmt.getLong("branch_id"), new Object[]{"gamma1: " + chStmt.getLong("gamma1"), "gamma2: " + chStmt.getLong("gamma2")});
                }
            }
        }

        private void populateAttributeTypeJoin(IdJoinQuery typeJoin) throws OseeCoreException {
            AttributeTypes types = FixDuplicateAttributesCommand.this.orcsApi.getOrcsTypes().getAttributeTypes();
            for (AttributeTypeId attributeType : types.getAll()) {
                if (types.getMaxOccurrences(attributeType) != 1) continue;
                typeJoin.add((Id)attributeType);
            }
            typeJoin.store();
        }
    }
}

