/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.conflict;

import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.core.enums.ConflictType;
import org.eclipse.osee.framework.core.enums.StorageState;
import org.eclipse.osee.framework.core.model.MergeBranch;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.db.internal.conflict.Conflict;

public final class ConflictUtil {
    private ConflictUtil() {
    }

    public static Conflict createConflict(MergeBranch mergeBranch, ChangeItem changeItem, ConflictStatus conflictStatus) throws OseeCoreException {
        ConflictType conflictType = ConflictUtil.toConflictType(changeItem);
        return new Conflict(StorageState.CREATED, changeItem.getItemId(), conflictType, mergeBranch, conflictStatus, changeItem.getCurrentVersion().getGammaId(), changeItem.getDestinationVersion().getGammaId());
    }

    public static boolean areGammasEqual(Conflict object1, Conflict object2) {
        boolean result = false;
        if (object1 == null && object2 == null) {
            result = true;
        } else if (object1 != null && object2 != null) {
            result = object1.getSourceGammaId().equals(object2.getSourceGammaId()) && object1.getDestinationGammaId().equals(object2.getDestinationGammaId());
        }
        return result;
    }

    public static ConflictStatus computeNetStatus(Conflict newConflict, Conflict storedConflict) {
        ConflictStatus netStatus = newConflict.getStatus();
        ConflictStatus storedStatus = storedConflict.getStatus();
        if (storedConflict.getStatus().isIgnoreable() || newConflict.getStatus().isIgnoreable()) {
            netStatus = newConflict.getStatus();
        } else if (!ConflictUtil.areGammasEqual(newConflict, storedConflict) && !storedStatus.isCommitted()) {
            if (storedStatus.isResolved() || storedStatus.isPreviousMergeSuccessfullyApplied()) {
                netStatus = ConflictStatus.OUT_OF_DATE_RESOLVED;
            }
            if (storedStatus.isEdited() || storedStatus.isPreviousMergeAppliedWithCaution()) {
                netStatus = ConflictStatus.OUT_OF_DATE;
            }
            newConflict.getType();
        }
        return netStatus;
    }

    public static ConflictType toConflictType(ChangeItem item) throws OseeCoreException {
        ConflictType type = null;
        switch (item.getChangeType()) {
            case ARTIFACT_CHANGE: {
                type = ConflictType.ARTIFACT;
                break;
            }
            case ATTRIBUTE_CHANGE: {
                type = ConflictType.ATTRIBUTE;
                break;
            }
            case RELATION_CHANGE: {
                type = ConflictType.RELATION;
                break;
            }
            default: {
                throw new OseeArgumentException("Unable to convert change item [%s] to conflict type", new Object[]{item});
            }
        }
        return type;
    }
}

