/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.change;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.executor.admin.HasCancellation;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.DataLoader;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.LoadDataHandlerAdapter;
import org.eclipse.osee.orcs.core.ds.OrcsData;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.db.internal.change.MissingChangeItemFactory;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;

public class MissingChangeItemFactoryImpl
implements MissingChangeItemFactory {
    private final DataLoaderFactory dataLoaderFactory;
    private HashMap<Long, ApplicabilityToken> applicTokensForMissingArts = null;

    public MissingChangeItemFactoryImpl(DataLoaderFactory dataModuleFactory) {
        this.dataLoaderFactory = dataModuleFactory;
    }

    @Override
    public Collection<ChangeItem> createMissingChanges(HasCancellation cancellation, OrcsSession session, List<ChangeItem> changes, TransactionToken sourceTx, TransactionToken destTx, ApplicabilityQuery applicQuery) throws OseeCoreException {
        if (changes != null && !changes.isEmpty()) {
            HashSet<Integer> modifiedArtIds = new HashSet<Integer>();
            LinkedListMultimap modifiedAttrIds = LinkedListMultimap.create();
            LinkedListMultimap modifiedRels = LinkedListMultimap.create();
            LinkedListMultimap modifiedTuples = LinkedListMultimap.create();
            block6: for (ChangeItem change : changes) {
                switch (change.getChangeType()) {
                    case ARTIFACT_CHANGE: {
                        if (change.isSynthetic()) continue block6;
                        modifiedArtIds.add(change.getArtId().getId().intValue());
                        break;
                    }
                    case ATTRIBUTE_CHANGE: {
                        modifiedAttrIds.put((Object)change.getArtId().getId().intValue(), (Object)change.getItemId().getId().intValue());
                        break;
                    }
                    case RELATION_CHANGE: {
                        modifiedRels.put((Object)change.getArtId().getId().intValue(), (Object)change.getItemId().getId().intValue());
                        modifiedRels.put((Object)change.getArtIdB().getId().intValue(), (Object)change.getItemId().getId().intValue());
                        break;
                    }
                    case TUPLE_CHANGE: {
                        modifiedTuples.put((Object)0L, (Object)1L);
                        break;
                    }
                    default: {
                        throw new OseeStateException("Unknonw change type detected [%s]", new Object[]{change});
                    }
                }
            }
            HashSet<Integer> allArtIds = new HashSet<Integer>(modifiedArtIds);
            allArtIds.addAll(modifiedAttrIds.keySet());
            allArtIds.addAll(modifiedRels.keySet());
            Set<Integer> missingArtIds = this.determineWhichArtifactsNotOnDestination(cancellation, session, allArtIds, destTx);
            if (!missingArtIds.isEmpty()) {
                this.applicTokensForMissingArts = applicQuery.getApplicabilityTokens(sourceTx.getBranch(), destTx.getBranch());
                return this.createMissingChangeItems(cancellation, session, sourceTx, destTx, modifiedArtIds, (Multimap<Integer, Integer>)modifiedAttrIds, (Multimap<Integer, Integer>)modifiedRels, missingArtIds, allArtIds);
            }
        }
        return Collections.emptyList();
    }

    private ApplicabilityToken getApplicabilityToken(ApplicabilityId appId) {
        Conditions.checkNotNull((Object)appId, (String)"ApplicabilityId");
        ApplicabilityToken toReturn = ApplicabilityToken.BASE;
        if (this.applicTokensForMissingArts != null && (toReturn = this.applicTokensForMissingArts.get(appId.getId())) == null) {
            toReturn = ApplicabilityToken.BASE;
        }
        return toReturn;
    }

    private Set<Integer> determineWhichArtifactsNotOnDestination(HasCancellation cancellation, OrcsSession session, Set<Integer> artIds, TransactionToken destTx) throws OseeCoreException {
        DataLoader loader = this.dataLoaderFactory.newDataLoaderFromIds(session, destTx.getBranch(), artIds);
        final LinkedHashSet<Integer> missingArtIds = new LinkedHashSet<Integer>(artIds);
        loader.includeDeletedArtifacts();
        loader.fromTransaction((TransactionId)destTx);
        loader.fromBranchView(destTx.getBranch().getViewId());
        loader.load(cancellation, (LoadDataHandler)new LoadDataHandlerAdapter(){

            public void onData(ArtifactData data) {
                missingArtIds.remove(data.getLocalId());
            }
        });
        return missingArtIds;
    }

    private Collection<ChangeItem> createMissingChangeItems(HasCancellation cancellation, OrcsSession session, TransactionToken sourceTx, TransactionToken destTx, final Set<Integer> modifiedArtIds, final Multimap<Integer, Integer> modifiedAttrIds, final Multimap<Integer, Integer> modifiedRels, Set<Integer> missingArtIds, Set<Integer> allArtIds) throws OseeCoreException {
        final LinkedHashSet<ChangeItem> toReturn = new LinkedHashSet<ChangeItem>();
        final LinkedHashSet relations = new LinkedHashSet();
        DataLoader loader = this.dataLoaderFactory.newDataLoaderFromIds(session, sourceTx.getBranch(), missingArtIds);
        loader.withLoadLevel(LoadLevel.ALL);
        loader.includeDeletedArtifacts();
        loader.fromTransaction((TransactionId)sourceTx);
        loader.fromBranchView(sourceTx.getBranch().getViewId());
        loader.load(cancellation, (LoadDataHandler)new LoadDataHandlerAdapter(){

            public void onData(ArtifactData data) throws OseeCoreException {
                if (!modifiedArtIds.contains(data.getLocalId())) {
                    toReturn.add(MissingChangeItemFactoryImpl.this.createArtifactChangeItem(data));
                }
            }

            public void onData(RelationData data) {
                int localId = (Integer)data.getLocalId();
                if (!modifiedRels.get((Object)data.getArtIdA()).contains(localId) && !modifiedRels.get((Object)data.getArtIdB()).contains(localId)) {
                    relations.add(data);
                }
            }

            public void onData(AttributeData data) throws OseeCoreException {
                if (!modifiedAttrIds.get((Object)data.getArtifactId()).contains(data.getLocalId())) {
                    toReturn.add(MissingChangeItemFactoryImpl.this.createAttributeChangeItem(data));
                }
            }
        });
        if (!relations.isEmpty()) {
            LinkedListMultimap relationChangesToAdd = LinkedListMultimap.create();
            for (RelationData data : relations) {
                if (allArtIds.contains(data.getArtIdA())) {
                    if (allArtIds.contains(data.getArtIdB())) {
                        toReturn.add(this.createRelationChangeItem(data));
                        continue;
                    }
                    relationChangesToAdd.put((Object)data.getArtIdB(), (Object)data);
                    continue;
                }
                if (!allArtIds.contains(data.getArtIdB())) continue;
                relationChangesToAdd.put((Object)data.getArtIdA(), (Object)data);
            }
            if (!relationChangesToAdd.isEmpty()) {
                toReturn.addAll(this.createExistingRelations(cancellation, session, destTx, (Multimap<Integer, RelationData>)relationChangesToAdd));
            }
        }
        return toReturn;
    }

    private Set<ChangeItem> createExistingRelations(HasCancellation cancellation, OrcsSession session, TransactionToken destTx, final Multimap<Integer, RelationData> relationChangesToAdd) throws OseeCoreException {
        final LinkedHashSet<ChangeItem> toReturn = new LinkedHashSet<ChangeItem>();
        DataLoader loader = this.dataLoaderFactory.newDataLoaderFromIds(session, destTx.getBranch(), (Collection)relationChangesToAdd.keySet());
        loader.fromTransaction((TransactionId)destTx);
        loader.fromBranchView(destTx.getBranch().getViewId());
        loader.load(cancellation, (LoadDataHandler)new LoadDataHandlerAdapter(){

            public void onData(ArtifactData data) throws OseeCoreException {
                for (RelationData relData : relationChangesToAdd.get((Object)((Integer)data.getLocalId()))) {
                    toReturn.add(MissingChangeItemFactoryImpl.this.createRelationChangeItem(relData));
                }
            }
        });
        return toReturn;
    }

    private ModificationType determineModType(OrcsData data) {
        if (data.getModType().matches(new ModificationType[]{ModificationType.DELETED, ModificationType.ARTIFACT_DELETED})) {
            return data.getModType();
        }
        return ModificationType.INTRODUCED;
    }

    private ChangeItem createArtifactChangeItem(ArtifactData data) throws OseeCoreException {
        ApplicabilityId appId = data.getApplicabilityId();
        ChangeItem artChange = ChangeItemUtil.newArtifactChange((ArtifactId)ArtifactId.valueOf((long)((Integer)data.getLocalId()).intValue()), (ArtifactTypeId)ArtifactTypeId.valueOf((Long)data.getTypeUuid()), (GammaId)GammaId.valueOf((long)data.getVersion().getGammaId()), (ModificationType)this.determineModType((OrcsData)data), (ApplicabilityToken)this.getApplicabilityToken(appId));
        return artChange;
    }

    private ChangeItem createAttributeChangeItem(AttributeData data) throws OseeCoreException {
        ApplicabilityId appId = data.getApplicabilityId();
        ChangeItem attrChange = ChangeItemUtil.newAttributeChange((AttributeId)data, (AttributeTypeId)AttributeTypeId.valueOf((Long)data.getTypeUuid()), (ArtifactId)ArtifactId.valueOf((long)data.getArtifactId()), (GammaId)GammaId.valueOf((long)data.getVersion().getGammaId()), (ModificationType)this.determineModType((OrcsData)data), (String)data.getDataProxy().getDisplayableString(), (ApplicabilityToken)this.getApplicabilityToken(appId));
        attrChange.getNetChange().copy(attrChange.getCurrentVersion());
        return attrChange;
    }

    private ChangeItem createRelationChangeItem(RelationData data) throws OseeCoreException {
        ApplicabilityId appId = data.getApplicabilityId();
        return ChangeItemUtil.newRelationChange((RelationId)RelationId.valueOf((Long)((Object)((Integer)data.getLocalId()))), (RelationTypeId)RelationTypeId.valueOf((Long)data.getTypeUuid()), (GammaId)GammaId.valueOf((long)data.getVersion().getGammaId()), (ModificationType)this.determineModType((OrcsData)data), (ArtifactId)ArtifactId.valueOf((long)data.getArtIdA()), (ArtifactId)ArtifactId.valueOf((long)data.getArtIdB()), (String)data.getRationale(), (ApplicabilityToken)this.getApplicabilityToken(appId));
    }
}

