/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.change;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.jdk.core.type.DoubleKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.data.TransactionTokenDelta;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.ExportImportJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;

public class LoadDeltasBetweenTxsOnTheSameBranch
extends AbstractDatastoreCallable<List<ChangeItem>> {
    private static final String SELECT_ITEMS_BETWEEN_TRANSACTIONS = "with txsOuter as (select gamma_id, mod_type, app_id from osee_txs%s where branch_id = ? and transaction_id > ? and transaction_id <= ?) \nSELECT 1 as table_type, attr_type_id as item_type_id, attr_id as item_id, art_id as item_first, 0 as item_second, 0 as item_third, 0 as item_fourth, value as item_value, item.gamma_id, mod_type, app_id \nFROM osee_attribute item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 2 as table_type, art_type_id as item_type_id, art_id as item_id, 0 as item_first, 0 as item_second, 0 as item_third, 0 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id \nFROM osee_artifact item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 3 as table_type, rel_link_type_id as item_type_id, rel_link_id as item_id,  a_art_id as item_first, b_art_id as item_second, 0 as item_third, 0 as item_fourth, rationale as item_value, item.gamma_id, mod_type, app_id \nFROM osee_relation_link item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 4 as table_type, tuple_type as item_type_id, 0 as item_id, e1 as item_first, e2 as item_second, 0 as item_third, 0 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id \nfrom osee_tuple2 item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 5 as table_type, tuple_type as item_type_id, 0 as item_id, e1 as item_first, e2 as item_second, e3 as item_third, 0 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id \nfrom osee_tuple3 item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 6 as table_type, tuple_type as item_type_id, 0 as item_id, e1 as item_first, e2 as item_second, e3 as item_third, e4 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id \nfrom osee_tuple4 item, txsOuter where txsOuter.gamma_id = item.gamma_id";
    private static final String SELECT_IS_BRANCH_ARCHIVED = "select archived from osee_branch where branch_id = ?";
    private final SqlJoinFactory joinFactory;
    private final TransactionTokenDelta txDelta;
    private final HashMap<Long, ApplicabilityToken> applicTokens;

    public LoadDeltasBetweenTxsOnTheSameBranch(Log logger, OrcsSession session, JdbcClient jdbcClient, SqlJoinFactory joinFactory, TransactionTokenDelta txDelta, ApplicabilityQuery applicQuery) {
        super(logger, session, jdbcClient);
        this.joinFactory = joinFactory;
        this.txDelta = txDelta;
        this.applicTokens = applicQuery.getApplicabilityTokens(txDelta.getStartTx().getBranch());
    }

    private ApplicabilityToken getApplicabilityToken(ApplicabilityId appId) {
        ApplicabilityToken toReturn = this.applicTokens.get(appId.getId());
        if (toReturn != null) {
            return toReturn;
        }
        return ApplicabilityToken.BASE;
    }

    private TransactionToken getEndTx() {
        return this.txDelta.getEndTx();
    }

    private TransactionToken getStartTx() {
        return this.txDelta.getStartTx();
    }

    public List<ChangeItem> call() throws Exception {
        Conditions.checkExpressionFailOnTrue((!this.txDelta.areOnTheSameBranch() ? 1 : 0) != 0, (String)"Unable to compute deltas between transactions on different branches [%s]", (Object[])new Object[]{this.txDelta});
        Integer result = (Integer)this.getJdbcClient().fetchOrException(Integer.class, () -> new OseeCoreException("Failed to get Branch archived state for %s", new Object[]{this.getEndTx().getBranch()}), SELECT_IS_BRANCH_ARCHIVED, new Object[]{this.getEndTx().getBranch()});
        Integer archived = (int)result;
        boolean isArchived = archived.equals(BranchArchivedState.ARCHIVED.getValue());
        DoubleKeyHashMap<Integer, Long, ChangeItem> hashChangeData = this.loadChangesAtEndTx(isArchived);
        return this.loadItemsByItemId(hashChangeData, isArchived);
    }

    private DoubleKeyHashMap<Integer, Long, ChangeItem> loadChangesAtEndTx(boolean isArchived) throws OseeCoreException {
        DoubleKeyHashMap hashChangeData = new DoubleKeyHashMap();
        Consumer<JdbcStatement> consumer = stmt -> {
            this.checkForCancelled();
            GammaId gammaId = GammaId.valueOf((long)stmt.getLong("gamma_id"));
            ModificationType modType = ModificationType.getMod((int)stmt.getInt("mod_type"));
            ApplicabilityId appId = ApplicabilityId.valueOf((long)stmt.getLong("app_id"));
            int tableType = stmt.getInt("table_type");
            Long itemId = stmt.getLong("item_id");
            Long itemTypeId = stmt.getLong("item_type_id");
            switch (tableType) {
                case 1: {
                    ArtifactId artId = ArtifactId.valueOf((long)stmt.getLong("item_first"));
                    String value = stmt.getString("item_value");
                    hashChangeData.put((Object)1, (Object)itemId, (Object)ChangeItemUtil.newAttributeChange((AttributeId)AttributeId.valueOf((long)itemId), (AttributeTypeId)AttributeTypeId.valueOf((Long)itemTypeId), (ArtifactId)artId, (GammaId)gammaId, (ModificationType)modType, (String)value, (ApplicabilityToken)this.getApplicabilityToken(appId)));
                    break;
                }
                case 2: {
                    hashChangeData.put((Object)2, (Object)itemId, (Object)ChangeItemUtil.newArtifactChange((ArtifactId)ArtifactId.valueOf((long)itemId), (ArtifactTypeId)ArtifactTypeId.valueOf((Long)itemTypeId), (GammaId)gammaId, (ModificationType)modType, (ApplicabilityToken)this.getApplicabilityToken(appId)));
                    break;
                }
                case 3: {
                    ArtifactId aArtId = ArtifactId.valueOf((long)stmt.getLong("item_first"));
                    ArtifactId bArtId = ArtifactId.valueOf((long)stmt.getLong("item_second"));
                    String rationale = stmt.getString("item_value");
                    hashChangeData.put((Object)3, (Object)itemId, (Object)ChangeItemUtil.newRelationChange((RelationId)RelationId.valueOf((Long)itemId), (RelationTypeId)RelationTypeId.valueOf((Long)itemTypeId), (GammaId)gammaId, (ModificationType)modType, (ArtifactId)aArtId, (ArtifactId)bArtId, (String)rationale, (ApplicabilityToken)this.getApplicabilityToken(appId)));
                    break;
                }
                case 4: {
                    long e1 = stmt.getLong("item_first");
                    long e2 = stmt.getLong("item_second");
                    hashChangeData.put((Object)4, (Object)gammaId.getId(), (Object)ChangeItemUtil.newTupleChange((TupleTypeId)TupleTypeId.valueOf((long)itemTypeId), (GammaId)gammaId, (ApplicabilityToken)this.getApplicabilityToken(appId), (Long[])new Long[]{e1, e2}));
                    break;
                }
                case 5: {
                    long e1 = stmt.getLong("item_first");
                    long e2 = stmt.getLong("item_second");
                    long e3 = stmt.getLong("item_third");
                    hashChangeData.put((Object)5, (Object)gammaId.getId(), (Object)ChangeItemUtil.newTupleChange((TupleTypeId)TupleTypeId.valueOf((long)itemTypeId), (GammaId)gammaId, (ApplicabilityToken)this.getApplicabilityToken(appId), (Long[])new Long[]{e1, e2, e3}));
                    break;
                }
                case 6: {
                    long e1 = stmt.getLong("item_first");
                    long e2 = stmt.getLong("item_second");
                    long e3 = stmt.getLong("item_third");
                    long e4 = stmt.getLong("item_fourth");
                    hashChangeData.put((Object)6, (Object)gammaId.getId(), (Object)ChangeItemUtil.newTupleChange((TupleTypeId)TupleTypeId.valueOf((long)itemTypeId), (GammaId)gammaId, (ApplicabilityToken)this.getApplicabilityToken(appId), (Long[])new Long[]{e1, e2, e3, e4}));
                }
            }
        };
        String query = String.format(SELECT_ITEMS_BETWEEN_TRANSACTIONS, isArchived ? "_archived" : "");
        this.getJdbcClient().runQuery(consumer, 10000, query, new Object[]{this.getEndTx().getBranch(), this.getStartTx(), this.getEndTx()});
        return hashChangeData;
    }

    private List<ChangeItem> loadItemsByItemId(DoubleKeyHashMap<Integer, Long, ChangeItem> changeData, boolean isArchived) throws OseeCoreException {
        ExportImportJoinQuery idJoin = this.joinFactory.createExportImportJoinQuery();
        try {
            for (Integer i : changeData.getKeySetOne()) {
                for (ChangeItem item : changeData.get((Object)i)) {
                    idJoin.add((long)i, item.getItemId().getId());
                }
            }
            idJoin.store();
            this.loadCurrentVersionData(idJoin.getQueryId(), changeData, this.getStartTx(), isArchived);
        }
        finally {
            idJoin.delete();
        }
        LinkedList<ChangeItem> list = new LinkedList<ChangeItem>(changeData.allValues());
        return list;
    }

    private void loadCurrentVersionData(int queryId, DoubleKeyHashMap<Integer, Long, ChangeItem> changesByItemId, TransactionToken transactionLimit, boolean isArchived) throws OseeCoreException {
        Consumer<JdbcStatement> consumer = stmt -> {
            this.checkForCancelled();
            Long itemId = stmt.getLong("item_id");
            Integer tableType = stmt.getInt("table_type");
            GammaId gammaId = GammaId.valueOf((long)stmt.getLong("gamma_id"));
            ApplicabilityId appId = ApplicabilityId.valueOf((long)stmt.getLong("app_id"));
            ModificationType modType = ModificationType.getMod((int)stmt.getInt("mod_type"));
            ChangeItem change = (ChangeItem)changesByItemId.get((Object)tableType, (Object)itemId);
            change.getDestinationVersion().setModType(modType);
            change.getDestinationVersion().setGammaId(gammaId);
            change.getDestinationVersion().setApplicabilityToken(this.getApplicabilityToken(appId));
            change.getBaselineVersion().copy(change.getDestinationVersion());
        };
        String archiveTable = isArchived ? "osee_txs_archived" : "osee_txs";
        String query = String.format("select txs.gamma_id, txs.mod_type, txs.app_id, item.art_id as item_id, 2 as table_type, transaction_id from osee_join_export_import idj, osee_artifact item, %s txs where idj.query_id = ? and idj.id2 = item.art_id and idj.id1 = 2 and item.gamma_id = txs.gamma_id and txs.branch_id = ? and txs.transaction_id <= ? union all select txs.gamma_id, txs.mod_type, txs.app_id, item.attr_id as item_id, 1 as table_type, transaction_id from osee_join_export_import idj, osee_attribute item, %s txs where idj.query_id = ? and idj.id2 = item.attr_id and idj.id1 = 1 and item.gamma_id = txs.gamma_id and txs.branch_id = ? and txs.transaction_id <= ? union all select txs.gamma_id, txs.mod_type, txs.app_id, item.rel_link_id as item_id, 3 as table_type, transaction_id from osee_join_export_import idj, osee_relation_link item, %s txs where idj.query_id = ? and idj.id2 = item.rel_link_id and idj.id1 = 3 and item.gamma_id = txs.gamma_id and txs.branch_id = ? and txs.transaction_id <= ? ORDER BY transaction_id", archiveTable, archiveTable, archiveTable);
        this.getJdbcClient().runQuery(consumer, 10000, query, new Object[]{queryId, transactionLimit.getBranch(), transactionLimit, queryId, transactionLimit.getBranch(), transactionLimit, queryId, transactionLimit.getBranch(), transactionLimit});
    }
}

