/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.change;

import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;

public class ComputeNetChangeCallable
extends CancellableCallable<List<ChangeItem>> {
    private final List<ChangeItem> changes;

    public ComputeNetChangeCallable(List<ChangeItem> changes) {
        this.changes = changes;
    }

    public List<ChangeItem> call() throws Exception {
        if (this.changes != null) {
            Iterator<ChangeItem> iterator = this.changes.iterator();
            while (iterator.hasNext()) {
                this.checkForCancelled();
                ChangeItem change = iterator.next();
                ChangeItemUtil.checkAndSetIgnoreCase((ChangeItem)change);
                if (!ChangeItemUtil.isModType((ChangeVersion)change.getNetChange(), (ModificationType)ModificationType.MERGED)) {
                    ModificationType netModType = this.getNetModType(change);
                    if (netModType == null) {
                        throw new OseeStateException("Net Mod Type was null", new Object[0]);
                    }
                    change.getNetChange().copy(change.getCurrentVersion());
                    change.getNetChange().setModType(netModType);
                    continue;
                }
                if (!ChangeItemUtil.isDeleted((ChangeVersion)change.getCurrentVersion())) continue;
                change.getNetChange().copy(change.getCurrentVersion());
            }
        }
        return this.changes;
    }

    private ModificationType getNetModType(ChangeItem change) {
        ModificationType modificationType = this.calculateNetWithDestinationBranch(change);
        return modificationType;
    }

    private ModificationType calculateNetWithDestinationBranch(ChangeItem change) {
        ModificationType netModType = change.getCurrentVersion().getModType();
        if (change.getDestinationVersion().isValid() && (change.getBaselineVersion().isValid() || change.getFirstNonCurrentChange().isValid())) {
            netModType = change.getCurrentVersion().getModType();
        } else if (ChangeItemUtil.wasNewOnSource((ChangeItem)change)) {
            netModType = ModificationType.NEW;
        } else if (ChangeItemUtil.wasIntroducedOnSource((ChangeItem)change)) {
            netModType = ModificationType.INTRODUCED;
        } else if (!change.getDestinationVersion().isValid()) {
            netModType = !change.getBaselineVersion().isValid() ? ModificationType.NEW : ModificationType.INTRODUCED;
        }
        return netModType;
    }
}

