/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.change;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeIgnoreType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;

public class AddSyntheticArtifactChangeData {
    private final List<ChangeItem> changeItems;

    public AddSyntheticArtifactChangeData(List<ChangeItem> changeItems) {
        this.changeItems = changeItems;
    }

    public List<ChangeItem> doWork() throws Exception {
        HashMap<ArtifactId, ChangeItem> artifactChanges = new HashMap<ArtifactId, ChangeItem>();
        for (ChangeItem item : this.changeItems) {
            if (!item.getChangeType().isArtifactChange()) continue;
            artifactChanges.put(item.getArtId(), item);
        }
        ArrayList<ChangeItem> attrItems = new ArrayList<ChangeItem>();
        HashMap<ArtifactId, ChangeItem> syntheticArtifactChanges = new HashMap<ArtifactId, ChangeItem>();
        for (ChangeItem item : this.changeItems) {
            ChangeItem attributeChange;
            ArtifactId artIdToCheck;
            ChangeItem artifactChange;
            if (!item.getChangeType().isAttributeChange() || (artifactChange = (ChangeItem)artifactChanges.get(artIdToCheck = (attributeChange = item).getArtId())) != null) continue;
            artifactChange = (ChangeItem)syntheticArtifactChanges.get(artIdToCheck);
            if (artifactChange == null) {
                artifactChange = ChangeItemUtil.newArtifactChange((ArtifactId)artIdToCheck, (ArtifactTypeId)ArtifactTypeId.SENTINEL, (GammaId)GammaId.valueOf((long)-1L), null, null);
                syntheticArtifactChanges.put(artIdToCheck, artifactChange);
                artifactChange.setSynthetic(true);
            }
            attrItems.add(attributeChange);
            this.updateArtifactChangeItem(artifactChange, attributeChange);
        }
        for (ChangeItem change : syntheticArtifactChanges.values()) {
            if (!AddSyntheticArtifactChangeData.isAllowableChange(change.getIgnoreType())) continue;
            this.changeItems.add(change);
        }
        return this.changeItems;
    }

    private void updateArtifactChangeItem(ChangeItem artifact, ChangeItem attribute) {
        try {
            if (attribute.getBaselineVersion().isValid()) {
                ChangeItemUtil.copy((ChangeVersion)attribute.getBaselineVersion(), (ChangeVersion)artifact.getBaselineVersion());
            }
            if (attribute.getCurrentVersion().isValid()) {
                ChangeItemUtil.copy((ChangeVersion)attribute.getCurrentVersion(), (ChangeVersion)artifact.getCurrentVersion());
            }
            if (attribute.getDestinationVersion().isValid()) {
                ChangeItemUtil.copy((ChangeVersion)attribute.getDestinationVersion(), (ChangeVersion)artifact.getDestinationVersion());
            }
            if (attribute.getNetChange().isValid()) {
                ChangeItemUtil.copy((ChangeVersion)attribute.getNetChange(), (ChangeVersion)artifact.getNetChange());
                artifact.getNetChange().setModType(ModificationType.MODIFIED);
            }
            if (artifact.getIgnoreType().isInvalid() || !AddSyntheticArtifactChangeData.isAllowableChange(artifact.getIgnoreType())) {
                ChangeItemUtil.checkAndSetIgnoreCase((ChangeItem)artifact);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isAllowableChange(ChangeIgnoreType ignoreType) {
        return ignoreType.isNone() || ignoreType.isResurrected() || ignoreType.isDeletedOnDestAndNotResurrected() || ignoreType.isDeletedOnDestination();
    }
}

