/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;

public class SetTransactionTxCallable
extends AbstractDatastoreTxCallable<Void> {
    private static final String UPDATE_TRANSACTION_COMMENT = "UPDATE osee_tx_details SET osee_comment = ? WHERE transaction_id = ?";
    private final TransactionId txs;
    private final String comment;

    public SetTransactionTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, TransactionId txs, String comment) {
        super(logger, session, jdbcClient);
        this.txs = txs;
        this.comment = comment;
    }

    @Override
    protected Void handleTxWork(JdbcConnection connection) throws OseeCoreException {
        Conditions.checkNotNull((Object)this.txs, (String)"transaction");
        Conditions.checkNotNullOrEmpty((String)this.comment, (String)"comment");
        this.getJdbcClient().runPreparedUpdate(connection, UPDATE_TRANSACTION_COMMENT, new Object[]{this.comment, this.txs});
        return null;
    }
}

