/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class PurgeTransactionTxCallable
extends AbstractDatastoreTxCallable<Integer> {
    private static final String UPDATE_TXS_DETAILS_COMMENT = "UPDATE osee_tx_details SET osee_comment = replace(osee_comment, ?, ?) WHERE osee_comment like ?";
    private static final String DELETE_TXS = "delete from osee_txs where branch_id = ? and transaction_id = ?";
    private static final String DELETE_TX_DETAILS = "delete from osee_tx_details where branch_id = ? and transaction_id = ?";
    private static final String SELECT_AFFECTED_ITEMS = "SELECT %s as item_id from osee_txs txs, %s item where txs.branch_id = ? and txs.transaction_id = ? AND txs.gamma_id = item.gamma_id";
    private static final String FIND_NEW_TX_CURRENTS = "SELECT oj.id as item_id, txs.mod_type, txs.gamma_id, txs.transaction_id from osee_join_id oj, %s item, osee_txs txs where oj.query_id = ? and oj.id = item.%s and item.gamma_id = txs.gamma_id and txs.branch_id = ? order by oj.id desc, txs.transaction_id desc";
    private static final String UPDATE_TX_CURRENT = "update osee_txs set tx_current = ? where branch_id = ? and transaction_id = ? and gamma_id = ?";
    private static final String GET_PRIOR_TRANSACTION = "select max(transaction_id) FROM osee_tx_details where branch_id = ? and transaction_id < ?";
    private static final String SELECT_TRANSACTION_BRANCH_ID = "select branch_id from osee_tx_details WHERE transaction_id = ?";
    private final SqlJoinFactory joinFactory;
    private final Collection<? extends TransactionId> txIdsToDelete;

    public PurgeTransactionTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, SqlJoinFactory joinFactory, Collection<? extends TransactionId> txIdsToDelete) {
        super(logger, session, jdbcClient);
        this.joinFactory = joinFactory;
        this.txIdsToDelete = txIdsToDelete;
    }

    private List<TransactionId> sortTxs(Collection<? extends TransactionId> txIdsToDelete) {
        ArrayList<TransactionId> txs = new ArrayList<TransactionId>(txIdsToDelete);
        if (txs.size() > 1) {
            Collections.sort(txs, new Comparator<TransactionId>(){

                @Override
                public int compare(TransactionId o1, TransactionId o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
        }
        return txs;
    }

    @Override
    protected Integer handleTxWork(JdbcConnection connection) throws OseeCoreException {
        Conditions.checkNotNull(this.txIdsToDelete, (String)"transaction ids to delete");
        Conditions.checkExpressionFailOnTrue((boolean)this.txIdsToDelete.isEmpty(), (String)"transaction ids to delete cannot be empty", (Object[])new Object[0]);
        List<TransactionId> txIds = this.sortTxs(this.txIdsToDelete);
        int purgeCount = 0;
        for (TransactionId txIdToDelete : txIds) {
            this.getLogger().info("Purging Transaction: [%s]", new Object[]{txIdToDelete});
            ArrayList<Object[]> txsToDelete = new ArrayList<Object[]>();
            BranchId txBranchId = (BranchId)this.getJdbcClient().fetch((Object)BranchId.SENTINEL, SELECT_TRANSACTION_BRANCH_ID, new Object[]{txIdToDelete});
            if (txBranchId.isInvalid()) {
                throw new OseeArgumentException("Cannot find branch for transaction record [%s]", new Object[]{txIdToDelete});
            }
            txsToDelete.add(new Object[]{txBranchId, txIdToDelete});
            TransactionId previousTransactionId = (TransactionId)this.getJdbcClient().fetch((Object)TransactionId.SENTINEL, GET_PRIOR_TRANSACTION, new Object[]{txBranchId, txIdToDelete});
            if (previousTransactionId.isInvalid()) {
                throw new OseeArgumentException("You are trying to delete transaction [%d] which is a baseline transaction.  If your intent is to delete the Branch use the delete Branch Operation.  \n\nNO TRANSACTIONS WERE DELETED.", new Object[]{txIdToDelete});
            }
            Map<BranchId, IdJoinQuery> arts = this.findAffectedItems(connection, "art_id", "osee_artifact", txsToDelete);
            Map<BranchId, IdJoinQuery> attrs = this.findAffectedItems(connection, "attr_id", "osee_attribute", txsToDelete);
            Map<BranchId, IdJoinQuery> rels = this.findAffectedItems(connection, "rel_link_id", "osee_relation_link", txsToDelete);
            this.setChildBranchBaselineTxs(connection, txIdToDelete, previousTransactionId);
            this.getJdbcClient().runBatchUpdate(connection, DELETE_TX_DETAILS, txsToDelete);
            this.getJdbcClient().runBatchUpdate(connection, DELETE_TXS, txsToDelete);
            ArrayList<Object[]> updateData = new ArrayList<Object[]>();
            this.computeNewTxCurrents(connection, updateData, "art_id", "osee_artifact", arts);
            this.computeNewTxCurrents(connection, updateData, "attr_id", "osee_attribute", attrs);
            this.computeNewTxCurrents(connection, updateData, "rel_link_id", "osee_relation_link", rels);
            this.getJdbcClient().runBatchUpdate(connection, UPDATE_TX_CURRENT, updateData);
            ++purgeCount;
            this.getLogger().info("Transaction: [%s] - purged", new Object[]{txIdToDelete});
        }
        return purgeCount;
    }

    private void computeNewTxCurrents(JdbcConnection connection, Collection<Object[]> updateData, String itemId, String tableName, Map<BranchId, IdJoinQuery> affected) throws OseeCoreException {
        String query = String.format(FIND_NEW_TX_CURRENTS, tableName, itemId);
        for (Map.Entry<BranchId, IdJoinQuery> entry : affected.entrySet()) {
            BranchId branch = entry.getKey();
            IdJoinQuery joinQuery = entry.getValue();
            try (JdbcStatement statement = this.getJdbcClient().getStatement(connection);){
                statement.runPreparedQuery(10000, query, new Object[]{joinQuery.getQueryId(), branch});
                int previousItem = -1;
                while (statement.next()) {
                    int currentItem = statement.getInt("item_id");
                    if (previousItem == currentItem) continue;
                    ModificationType modType = ModificationType.getMod((int)statement.getInt("mod_type"));
                    TxChange txCurrent = TxChange.getCurrent((ModificationType)modType);
                    updateData.add(new Object[]{txCurrent.getValue(), branch, statement.getLong("transaction_id"), statement.getLong("gamma_id")});
                    previousItem = currentItem;
                }
            }
            finally {
                joinQuery.delete(connection);
            }
        }
    }

    private Map<BranchId, IdJoinQuery> findAffectedItems(JdbcConnection connection, String itemId, String itemTable, List<Object[]> bindDataList) throws OseeCoreException {
        HashMap<BranchId, IdJoinQuery> items = new HashMap<BranchId, IdJoinQuery>();
        try (JdbcStatement statement = this.getJdbcClient().getStatement(connection);){
            for (Object[] bindData : bindDataList) {
                String query = String.format(SELECT_AFFECTED_ITEMS, itemId, itemTable);
                statement.runPreparedQuery(10000, query, bindData);
                IdJoinQuery joinId = this.joinFactory.createIdJoinQuery();
                items.put((BranchId)bindData[0], joinId);
                while (statement.next()) {
                    Integer id = statement.getInt("item_id");
                    joinId.add(id);
                }
                joinId.store();
            }
        }
        return items;
    }

    private void setChildBranchBaselineTxs(JdbcConnection connection, TransactionId toDeleteTransactionId, TransactionId previousTransactionId) throws OseeCoreException {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        if (previousTransactionId.isValid()) {
            data.add(new Object[]{String.valueOf(toDeleteTransactionId.getId()), String.valueOf(previousTransactionId), "%" + toDeleteTransactionId.getId()});
        }
        if (!data.isEmpty()) {
            this.getJdbcClient().runBatchUpdate(connection, UPDATE_TXS_DETAILS_COMMENT, data);
        }
    }
}

