/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.osee.framework.core.data.OrcsTypesData;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.framework.resource.management.StandardOptions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;

public class OrcsTypeLoaderCallable
extends AbstractDatastoreCallable<IResource> {
    private final IResourceManager resourceManager;

    public OrcsTypeLoaderCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, IResourceManager resourceManager) {
        super(logger, session, jdbcClient);
        this.resourceManager = resourceManager;
    }

    public IResource call() throws Exception {
        String resourceUri = String.format("osee:/datastore.orcs.types_%s.osee", Lib.getDateTimeString());
        URI uri = new URI(resourceUri);
        Collection<String> uriPaths = this.findOseeTypeData();
        Conditions.checkExpressionFailOnTrue((boolean)uriPaths.isEmpty(), (String)"No orcs types found", (Object[])new Object[0]);
        return new OrcsTypesResource(uri, uriPaths);
    }

    private Collection<String> findOseeTypeData() throws OseeCoreException {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        this.getJdbcClient().runQuery(stmt -> {
            String uri = stmt.getString("uri");
            paths.add(uri);
        }, "select uri, attr.attr_id from osee_tuple2 t2, osee_txs txs1, osee_attribute attr, osee_txs txs2 where tuple_type = ? and t2.gamma_id = txs1.gamma_id and txs1.branch_id = ? and txs1.tx_current = ? and e1 = ? and e2 = attr.attr_id and attr.gamma_id = txs2.gamma_id and txs2.branch_id = txs1.branch_id and txs2.tx_current = ?", new Object[]{CoreTupleTypes.OseeTypeDef, CoreBranches.COMMON, TxChange.CURRENT.getValue(), OrcsTypesData.OSEE_TYPE_VERSION, TxChange.CURRENT.getValue()});
        return paths;
    }

    private final class OrcsTypesResource
    implements IResource {
        private final URI uri;
        private final Collection<String> resources;

        public OrcsTypesResource(URI uri, Collection<String> resources) {
            this.uri = uri;
            this.resources = resources;
        }

        public InputStream getContent() throws OseeCoreException {
            return this.asInputStream(this.resources);
        }

        public URI getLocation() {
            return this.uri;
        }

        public String getName() {
            String value = this.uri.toASCIIString();
            return value.substring(value.lastIndexOf("/") + 1, value.length());
        }

        public boolean isCompressed() {
            return false;
        }

        private InputStream asInputStream(Collection<String> resources) throws OseeCoreException {
            PropertyStore options = new PropertyStore();
            options.put(StandardOptions.DecompressOnAquire.name(), "true");
            OrcsTypeLoaderCallable.this.getLogger().info("osee types uri [" + this.uri + "] resources [" + resources + "]", new Object[0]);
            StringBuilder builder = new StringBuilder();
            for (String path : resources) {
                IResourceLocator locator = OrcsTypeLoaderCallable.this.resourceManager.getResourceLocator(path);
                IResource resource = OrcsTypeLoaderCallable.this.resourceManager.acquire(locator, options);
                if (resource == null) {
                    throw new OseeStateException("Types resource can not be null for %s", new Object[]{path});
                }
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = resource.getContent();
                        String oseeTypeFragment = Lib.inputStreamToString((InputStream)inputStream);
                        oseeTypeFragment = oseeTypeFragment.replaceAll("import\\s+\"", "// import \"");
                        builder.append("\n//////////////     ");
                        builder.append(resource.getName());
                        builder.append("\n\n");
                        builder.append(oseeTypeFragment);
                    }
                    catch (IOException ex) {
                        OseeCoreException.wrapAndThrow((Throwable)ex);
                        Lib.close((Closeable)inputStream);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    Lib.close((Closeable)inputStream);
                    throw throwable;
                }
                Lib.close((Closeable)inputStream);
            }
            InputStream toReturn = null;
            try {
                toReturn = Lib.stringToInputStream((String)builder.toString());
            }
            catch (UnsupportedEncodingException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            return toReturn;
        }
    }
}

