/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import com.google.common.base.Supplier;
import java.io.File;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.exception.OseeDataStoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcMigrationOptions;
import org.eclipse.osee.jdbc.JdbcMigrationResource;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.core.ds.DataStoreInfo;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.callable.FetchDatastoreInfoCallable;
import org.eclipse.osee.orcs.db.internal.resource.ResourceConstants;

public class InitializeDatastoreCallable
extends AbstractDatastoreCallable<DataStoreInfo> {
    private static final String ADD_PERMISSION = "INSERT INTO OSEE_PERMISSION (PERMISSION_ID, PERMISSION_NAME) VALUES (?,?)";
    private final SystemPreferences preferences;
    private final Supplier<Iterable<JdbcMigrationResource>> schemaProvider;
    private final JdbcMigrationOptions options;
    private final IdentityManager identityService;

    public InitializeDatastoreCallable(OrcsSession session, Log logger, JdbcClient jdbcClient, IdentityManager identityService, SystemPreferences preferences, Supplier<Iterable<JdbcMigrationResource>> schemaProvider, JdbcMigrationOptions options) {
        super(logger, session, jdbcClient);
        this.identityService = identityService;
        this.preferences = preferences;
        this.schemaProvider = schemaProvider;
        this.options = options;
    }

    public DataStoreInfo call() throws Exception {
        Conditions.checkExpressionFailOnTrue((boolean)this.getJdbcClient().getConfig().isProduction(), (String)"Error - attempting to initialize a production datastore.", (Object[])new Object[0]);
        this.getJdbcClient().migrate(this.options, (Iterable)this.schemaProvider.get());
        String attributeDataPath = ResourceConstants.getAttributeDataPath(this.preferences);
        this.getLogger().info("Deleting application server binary data [%s]...", new Object[]{attributeDataPath});
        Lib.deleteDir((File)new File(attributeDataPath));
        this.preferences.putValue("osee.db.guid", GUID.create());
        this.addDefaultPermissions();
        this.clearStateCaches();
        FetchDatastoreInfoCallable fetchCallable = new FetchDatastoreInfoCallable(this.getLogger(), this.getSession(), this.getJdbcClient(), this.schemaProvider, this.preferences);
        DataStoreInfo dataStoreInfo = (DataStoreInfo)this.callAndCheckForCancel(fetchCallable);
        return dataStoreInfo;
    }

    private void clearStateCaches() throws OseeDataStoreException {
        this.identityService.invalidateIds();
    }

    private void addDefaultPermissions() throws OseeCoreException {
        LinkedList<Object[]> data = new LinkedList<Object[]>();
        PermissionEnum[] permissionEnumArray = PermissionEnum.values();
        int n = permissionEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            PermissionEnum permission = permissionEnumArray[n2];
            data.add(new Object[]{permission.getPermId(), permission.getName()});
            ++n2;
        }
        this.getJdbcClient().runBatchUpdate(ADD_PERMISSION, data);
    }
}

