/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.ImportOptions;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.db.internal.IdentityLocator;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.exchange.ExchangeUtil;
import org.eclipse.osee.orcs.db.internal.exchange.IOseeExchangeDataProvider;
import org.eclipse.osee.orcs.db.internal.exchange.SavePointManager;
import org.eclipse.osee.orcs.db.internal.exchange.StandardOseeDbExportDataProvider;
import org.eclipse.osee.orcs.db.internal.exchange.TranslationManager;
import org.eclipse.osee.orcs.db.internal.exchange.handler.BaseDbSaxHandler;
import org.eclipse.osee.orcs.db.internal.exchange.handler.BranchDataSaxHandler;
import org.eclipse.osee.orcs.db.internal.exchange.handler.DbTableSaxHandler;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.handler.IExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ManifestSaxHandler;
import org.eclipse.osee.orcs.db.internal.exchange.handler.MetaData;
import org.eclipse.osee.orcs.db.internal.exchange.handler.MetaDataSaxHandler;
import org.eclipse.osee.orcs.db.internal.exchange.transform.ExchangeDataProcessor;
import org.eclipse.osee.orcs.db.internal.exchange.transform.ExchangeTransformProvider;
import org.eclipse.osee.orcs.db.internal.exchange.transform.ExchangeTransformer;
import org.eclipse.osee.orcs.db.internal.resource.ResourceConstants;
import org.xml.sax.ContentHandler;

public class ImportBranchDatabaseCallable
extends AbstractDatastoreCallable<URI> {
    private final SystemPreferences preferences;
    private final IResourceManager resourceManager;
    private final IdentityLocator identityService;
    private final OrcsTypes orcsTypes;
    private final SavePointManager savePointManager;
    private final URI exchangeFile;
    private final List<? extends BranchId> selectedBranches;
    private final PropertyStore options;
    private ExchangeTransformer exchangeTransformer;
    private ManifestSaxHandler manifestHandler;
    private TranslationManager translator;
    private MetaDataSaxHandler metadataHandler;
    private IOseeExchangeDataProvider exportDataProvider;
    private ExchangeDataProcessor exchangeDataProcessor;
    private long[] branchesToImport;

    public ImportBranchDatabaseCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, SystemPreferences preferences, IResourceManager resourceManager, IdentityLocator identityService, OrcsTypes orcsTypes, URI exchangeFile, List<? extends BranchId> selectedBranches, PropertyStore options) {
        super(logger, session, jdbcClient);
        this.preferences = preferences;
        this.resourceManager = resourceManager;
        this.identityService = identityService;
        this.orcsTypes = orcsTypes;
        this.savePointManager = new SavePointManager(jdbcClient);
        this.exchangeFile = exchangeFile;
        this.selectedBranches = selectedBranches;
        this.options = options;
    }

    public URI call() throws Exception {
        URI importedURI = null;
        this.checkPreconditions();
        this.savePointManager.clear();
        try {
            try {
                this.savePointManager.setCurrentSetPointId("start");
                this.savePointManager.addCurrentSavePointToProcessed();
                this.setup();
                URI modelUri = this.exportDataProvider.getFile(this.manifestHandler.getTypeModel()).toURI();
                this.loadTypeModel(modelUri);
                ImportBranchesTx importBranchesTx = new ImportBranchesTx(this.getLogger(), this.getSession(), this.getJdbcClient(), this.savePointManager, this.manifestHandler.getBranchFile());
                this.callAndCheckForCancel(importBranchesTx);
                this.savePointManager.setCurrentSetPointId("init_relational_objects");
                this.savePointManager.addCurrentSavePointToProcessed();
                this.branchesToImport = new long[this.selectedBranches.size()];
                int index = 0;
                for (BranchId branchId : this.selectedBranches) {
                    this.branchesToImport[index++] = branchId.getUuid();
                }
                this.processImportFiles(this.branchesToImport, this.manifestHandler.getImportFiles());
                importBranchesTx.updateBaselineAndParentTransactionId();
                this.exchangeTransformer.applyFinalTransforms();
                this.savePointManager.setCurrentSetPointId("stop");
                this.savePointManager.addCurrentSavePointToProcessed();
                importedURI = this.exportDataProvider.getExportedDataRoot().toURI();
            }
            catch (Throwable ex) {
                this.savePointManager.reportError(ex);
                this.getLogger().error(ex, "Error importing", new Object[0]);
                this.cleanup();
            }
        }
        finally {
            this.cleanup();
        }
        return importedURI;
    }

    private void checkPreconditions() throws OseeCoreException {
        if (this.getJdbcClient().getConfig().isProduction()) {
            throw new OseeStateException("DO NOT IMPORT ON PRODUCTION", new Object[0]);
        }
    }

    private IResourceLocator findResourceToCheck(URI fileToCheck) throws OseeCoreException {
        IResourceLocator locator = this.resourceManager.getResourceLocator(fileToCheck.toASCIIString());
        return locator;
    }

    private IOseeExchangeDataProvider createExportDataProvider(IResourceLocator exportDataLocator) throws OseeCoreException {
        String exchangeBasePath = ResourceConstants.getExchangeDataPath(this.preferences);
        Pair<Boolean, File> result = ExchangeUtil.getTempExchangeFile(exchangeBasePath, this.getLogger(), exportDataLocator, this.resourceManager);
        return new StandardOseeDbExportDataProvider(exchangeBasePath, this.getLogger(), (File)result.getSecond(), (Boolean)result.getFirst());
    }

    private void setup() throws Exception {
        IResourceLocator exportDataLocator = this.findResourceToCheck(this.exchangeFile);
        this.exportDataProvider = this.createExportDataProvider(exportDataLocator);
        this.exchangeDataProcessor = new ExchangeDataProcessor(this.exportDataProvider);
        this.savePointManager.setCurrentSetPointId("sourceSetup");
        ExchangeTransformProvider transformProvider = new ExchangeTransformProvider();
        this.exchangeTransformer = new ExchangeTransformer(this.getLogger(), this.getSession(), this.getJdbcClient(), transformProvider, this.exchangeDataProcessor);
        this.exchangeTransformer.applyTransforms();
        this.savePointManager.setCurrentSetPointId("manifest");
        this.manifestHandler = new ManifestSaxHandler();
        this.exchangeDataProcessor.parse(ExportItem.EXPORT_MANIFEST, (ContentHandler)((Object)this.manifestHandler));
        this.savePointManager.setCurrentSetPointId("setup");
        this.translator = new TranslationManager(this.getJdbcClient());
        this.translator.configure(this.options);
        this.savePointManager.setCurrentSetPointId(this.manifestHandler.getMetadataFile());
        this.metadataHandler = new MetaDataSaxHandler(this.getJdbcClient());
        this.exchangeDataProcessor.parse(ExportItem.EXPORT_DB_SCHEMA, (ContentHandler)((Object)this.metadataHandler));
        this.metadataHandler.checkAndLoadTargetDbMetadata();
        this.savePointManager.setCurrentSetPointId("load.translator");
        this.translator.loadTranslators(this.manifestHandler.getSourceDatabaseId());
        this.savePointManager.loadSavePoints(this.manifestHandler.getSourceDatabaseId(), this.manifestHandler.getSourceExportDate());
    }

    private void processImportFiles(long[] branchesToImport, Collection<IExportItem> importItems) throws Exception {
        DbTableSaxHandler handler = DbTableSaxHandler.createWithLimitedCache(this.getLogger(), this.getJdbcClient(), this.resourceManager, this.identityService, this.exportDataProvider, 50000);
        handler.setSelectedBranchIds(branchesToImport);
        for (IExportItem item : importItems) {
            this.getLogger().info("starting import for [%s]", new Object[]{item});
            this.savePointManager.setCurrentSetPointId(item.getSource());
            handler.setExportItem(item);
            if (!this.savePointManager.isCurrentInProcessed()) {
                this.process(handler, item);
                handler.store();
                handler.reset();
                this.savePointManager.addCurrentSavePointToProcessed();
                continue;
            }
            this.getLogger().info("Save point found for: [%s] - skipping", new Object[]{item.getSource()});
        }
    }

    private void process(BaseDbSaxHandler handler, IExportItem exportItem) throws OseeCoreException {
        MetaData metadata = this.checkMetadata(exportItem);
        handler.setMetaData(metadata);
        handler.setOptions(this.options);
        handler.setTranslator(this.translator);
        boolean cleanDataTable = this.options.getBoolean(ImportOptions.CLEAN_BEFORE_IMPORT.name());
        this.getLogger().info("Importing: [%s] %s Meta: %s", new Object[]{exportItem.getSource(), (cleanDataTable &= !this.savePointManager.isCurrentInProcessed()) ? "clean before import" : "", metadata.getColumnNames()});
        if (cleanDataTable) {
            handler.clearDataTable();
        }
        try {
            this.exchangeDataProcessor.parse(exportItem, (ContentHandler)((Object)handler));
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private MetaData checkMetadata(IExportItem importFile) throws OseeArgumentException {
        MetaData metadata = this.metadataHandler.getMetadata(importFile.getSource());
        if (metadata == null) {
            throw new OseeArgumentException("Invalid metadata for [%s]", new Object[]{importFile.getSource()});
        }
        return metadata;
    }

    private void cleanup() throws Exception {
        try {
            try {
                CommitImportSavePointsTx callable = new CommitImportSavePointsTx(this.getLogger(), this.getSession(), this.getJdbcClient());
                this.callAndCheckForCancel(callable);
            }
            catch (Exception ex) {
                this.getLogger().warn((Throwable)ex, "Error during save point save - you will not be able to reimport from last source again.", new Object[0]);
                throw ex;
            }
        }
        finally {
            this.exchangeDataProcessor.cleanUp();
            this.translator = null;
            this.manifestHandler = null;
            this.metadataHandler = null;
            this.exchangeTransformer = null;
            this.savePointManager.clear();
        }
    }

    private void loadTypeModel(final URI modelUri) throws Exception {
        IResource typesResource = new IResource(){

            public InputStream getContent() throws OseeCoreException {
                try {
                    URL url = modelUri.toURL();
                    return new BufferedInputStream(url.openStream());
                }
                catch (IOException ex) {
                    throw OseeCoreException.wrap((Throwable)ex);
                }
            }

            public URI getLocation() {
                return modelUri;
            }

            public String getName() {
                String name = modelUri.toASCIIString();
                int index = name.lastIndexOf("/");
                if (index > 0) {
                    name = name.substring(index + 1, name.length());
                }
                return name;
            }

            public boolean isCompressed() {
                return false;
            }
        };
        this.getLogger().info("Updating Type Model with [%s]", new Object[]{typesResource.getLocation()});
        this.orcsTypes.loadTypes(typesResource).call();
        this.getLogger().info("Type Model Import complete", new Object[0]);
    }

    private final class CommitImportSavePointsTx
    extends AbstractDatastoreTxCallable<Boolean> {
        private static final String IMPORT_ID_SEQ = "SKYNET_IMPORT_ID_SEQ";
        private static final String INSERT_INTO_IMPORT_SOURCES = "INSERT INTO osee_import_source (import_id, db_source_guid, source_export_date, date_imported) VALUES (?, ?, ?, ?)";

        public CommitImportSavePointsTx(Log logger, OrcsSession session, JdbcClient jdbcClient) {
            super(logger, session, jdbcClient);
        }

        @Override
        protected Boolean handleTxWork(JdbcConnection connection) throws OseeCoreException {
            if (ImportBranchDatabaseCallable.this.manifestHandler == null || ImportBranchDatabaseCallable.this.translator == null) {
                throw new OseeStateException("Import didn't make it past initialization", new Object[0]);
            }
            int importIdIndex = (int)this.getJdbcClient().getNextSequence(IMPORT_ID_SEQ, true);
            String sourceDatabaseId = ImportBranchDatabaseCallable.this.manifestHandler.getSourceDatabaseId();
            Timestamp importDate = new Timestamp(new Date().getTime());
            Timestamp exportDate = new Timestamp(ImportBranchDatabaseCallable.this.manifestHandler.getSourceExportDate().getTime());
            this.getJdbcClient().runPreparedUpdate(connection, INSERT_INTO_IMPORT_SOURCES, new Object[]{importIdIndex, sourceDatabaseId, exportDate, importDate});
            ImportBranchDatabaseCallable.this.translator.store(connection, importIdIndex);
            ImportBranchDatabaseCallable.this.savePointManager.storeSavePoints(connection, importIdIndex);
            return Boolean.TRUE;
        }
    }

    private final class ImportBranchesTx
    extends AbstractDatastoreTxCallable<Object> {
        private final SavePointManager savePointManager;
        private final BranchDataSaxHandler branchHandler;
        private final IExportItem branchExportItem;
        private long[] branchesStored;

        public ImportBranchesTx(Log logger, OrcsSession session, JdbcClient jdbcClient, SavePointManager savePointManager, IExportItem branchExportItem) {
            super(logger, session, jdbcClient);
            this.savePointManager = savePointManager;
            this.branchExportItem = branchExportItem;
            this.branchHandler = BranchDataSaxHandler.createWithCacheAll(logger, jdbcClient);
            this.branchesStored = new long[0];
        }

        public void updateBaselineAndParentTransactionId() throws OseeCoreException {
            this.savePointManager.setCurrentSetPointId("update_branch_baseline_parent_tx_ids");
            if (!this.savePointManager.isCurrentInProcessed()) {
                this.branchHandler.updateBaselineAndParentTransactionId(this.branchesStored);
                this.savePointManager.addCurrentSavePointToProcessed();
            } else {
                this.getLogger().info("Save point found for: [%s] - skipping", new Object[]{this.savePointManager.getCurrentSetPointId()});
            }
        }

        @Override
        protected Object handleTxWork(JdbcConnection connection) throws OseeCoreException {
            this.savePointManager.setCurrentSetPointId(this.branchExportItem.getSource());
            this.branchHandler.setConnection(connection);
            ImportBranchDatabaseCallable.this.process(this.branchHandler, this.branchExportItem);
            if (!this.savePointManager.isCurrentInProcessed()) {
                this.branchesStored = this.branchHandler.store(connection, true, ImportBranchDatabaseCallable.this.branchesToImport);
                this.savePointManager.addCurrentSavePointToProcessed();
            } else {
                this.getLogger().info("Save point found for: [%s] - skipping", new Object[]{this.savePointManager.getCurrentSetPointId()});
                this.branchesStored = this.branchHandler.store(connection, false, ImportBranchDatabaseCallable.this.branchesToImport);
            }
            return null;
        }

        @Override
        protected void handleTxFinally() throws OseeCoreException {
            super.handleTxFinally();
            this.branchHandler.setConnection(null);
        }
    }
}

