/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.ExportImportJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class ConsolidateRelationsDatabaseTxCallable
extends AbstractDatastoreTxCallable<Object> {
    private static final String SELECT_RELATIONS = "select * from osee_relation_link order by rel_link_type_id, a_art_id, b_art_id, gamma_id";
    private static final String SELECT_RELATION_ADDRESSING = "select txs.*, idj.id1 as net_gamma_id from osee_join_export_import idj, osee_txs txs where idj.query_id = ? and idj.id2 = txs.gamma_id order by net_gamma_id, transaction_id, id2";
    private static final String UPDATE_TXS_GAMMAS = "update osee_txs set gamma_id = ?, mod_type = ?, tx_current = ? where branch_id = ? and transaction_id = ? and gamma_id = ?";
    private static final String DELETE_TXS = "delete from osee_txs where branch_id = ? and transaction_id = ? and gamma_id = ?";
    private static final String DELETE_RELATIONS = "delete from osee_relation_link where gamma_id = ?";
    private final List<Object[]> relationDeleteData = new ArrayList<Object[]>(14000);
    private final List<Long> obsoleteGammas = new ArrayList<Long>();
    private final StringBuilder addressingBackup = new StringBuilder(100000);
    private final List<Object[]> addressingToDelete = new ArrayList<Object[]>(13000);
    private final List<Object[]> updateAddressingData = new ArrayList<Object[]>(5000);
    private ExportImportJoinQuery gammaJoin;
    private JdbcConnection connection;
    private long previousRelationTypeId;
    private int previousArtifactAId;
    private int previousArtiafctBId;
    private long netGamma;
    private String netRationale;
    boolean materiallyDifferent;
    boolean updateAddressing;
    private int counter;
    private JdbcStatement chStmt;
    private final SqlJoinFactory joinFactory;
    private final Console console;
    long previousNetGammaId;
    long previousObsoleteGammaId;
    long previousTransactionId;
    long previousBranchId;
    ModificationType netModType;
    TxChange netTxCurrent;

    public ConsolidateRelationsDatabaseTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, SqlJoinFactory joinFactory, Console console) {
        super(logger, session, jdbcClient);
        this.joinFactory = joinFactory;
        this.console = console;
    }

    private void init() throws OseeCoreException {
        this.previousRelationTypeId = -1L;
        this.previousArtifactAId = -1;
        this.previousArtiafctBId = -1;
        this.materiallyDifferent = true;
        this.relationDeleteData.clear();
        this.obsoleteGammas.clear();
        this.updateAddressingData.clear();
        this.addressingToDelete.clear();
        this.addressingBackup.delete(0, 999999999);
        this.updateAddressing = false;
        this.previousNetGammaId = -1L;
        this.previousTransactionId = -1L;
        this.previousBranchId = -1L;
        this.chStmt = this.getJdbcClient().getStatement();
        this.gammaJoin = this.joinFactory.createExportImportJoinQuery();
        this.counter = 0;
    }

    @Override
    protected Object handleTxWork(JdbcConnection connection) throws OseeCoreException {
        this.connection = connection;
        this.console.writeln((Object)"Consolidating relations:");
        this.init();
        this.findObsoleteRelations();
        this.console.writeln("gamma join size: [%s]", new Object[]{this.gammaJoin.size()});
        this.determineAffectedAddressing();
        this.updateGammas();
        this.console.writeln((Object)"...done.");
        return null;
    }

    private void findObsoleteRelations() throws OseeCoreException {
        try {
            this.chStmt.runPreparedQuery(10000, SELECT_RELATIONS, new Object[0]);
            while (this.chStmt.next()) {
                int artiafctBId;
                int artifactAId;
                long relationTypeId = this.chStmt.getLong("rel_link_type_id");
                if (this.isNextConceptualRelation(relationTypeId, artifactAId = this.chStmt.getInt("a_art_id"), artiafctBId = this.chStmt.getInt("b_art_id"))) {
                    this.consolidate();
                    this.initNextConceptualRelation(relationTypeId, artifactAId, artiafctBId);
                    continue;
                }
                this.obsoleteGammas.add(this.chStmt.getLong("gamma_id"));
                this.relationMateriallyDiffers(this.chStmt);
            }
        }
        finally {
            this.chStmt.close();
        }
    }

    private void consolidate() {
        if (!this.materiallyDifferent && this.obsoleteGammas.size() > 0) {
            this.gammaJoin.add(this.netGamma, this.netGamma);
            for (Long obsoleteGamma : this.obsoleteGammas) {
                this.gammaJoin.add(this.netGamma, obsoleteGamma);
                this.relationDeleteData.add(new Long[]{obsoleteGamma});
            }
        }
        if (this.materiallyDifferent) {
            ++this.counter;
            this.console.writeln("rel_type:[%s] a_art_id:[%s]  b_art_id:[%s]", new Object[]{this.previousRelationTypeId, this.previousArtifactAId, this.previousArtiafctBId});
        }
    }

    private void determineAffectedAddressing() throws OseeCoreException {
        this.gammaJoin.store();
        try {
            this.console.writeln("counter: [%s]", new Object[]{this.counter});
            this.console.writeln("query id: [%s]", new Object[]{this.gammaJoin.getQueryId()});
            this.chStmt.runPreparedQuery(10000, SELECT_RELATION_ADDRESSING, new Object[]{this.gammaJoin.getQueryId()});
            while (this.chStmt.next()) {
                long obsoleteGammaId = this.chStmt.getLong("gamma_id");
                long transactionId = this.chStmt.getLong("transaction_id");
                long netGammaId = this.chStmt.getLong("net_gamma_id");
                int modType = this.chStmt.getInt("mod_type");
                TxChange txCurrent = TxChange.getChangeType((int)this.chStmt.getInt("tx_current"));
                long branchId = this.chStmt.getLong("branch_id");
                if (this.isNextAddressing(netGammaId, transactionId)) {
                    if (this.updateAddressing) {
                        this.updateAddressingData.add(new Object[]{this.previousNetGammaId, this.netModType.getValue(), this.netTxCurrent.getValue(), this.previousBranchId, this.previousTransactionId, this.previousObsoleteGammaId});
                    }
                    this.updateAddressing = obsoleteGammaId != netGammaId;
                    this.previousNetGammaId = netGammaId;
                    this.previousObsoleteGammaId = obsoleteGammaId;
                    this.previousTransactionId = transactionId;
                    this.previousBranchId = branchId;
                    this.netModType = ModificationType.getMod((int)modType);
                    this.netTxCurrent = txCurrent;
                } else {
                    this.addressingToDelete.add(new Object[]{branchId, transactionId, obsoleteGammaId});
                    this.computeNetAddressing(ModificationType.getMod((int)modType), txCurrent);
                }
                this.writeAddressingBackup(obsoleteGammaId, transactionId, netGammaId, modType, txCurrent);
            }
        }
        finally {
            this.chStmt.close();
        }
        this.gammaJoin.delete();
    }

    private boolean isNextAddressing(long netGammaId, long transactionId) {
        return this.previousNetGammaId != netGammaId || this.previousTransactionId != transactionId;
    }

    private void computeNetAddressing(ModificationType modificationType, TxChange txCurrent) throws OseeStateException {
        if (this.netTxCurrentNeedsUpdate(txCurrent)) {
            this.netTxCurrent = txCurrent;
            this.updateAddressing = true;
        }
        if (this.netModTypeNeedsUpdate(modificationType)) {
            this.netModType = modificationType;
            this.updateAddressing = true;
        } else if (!this.ignoreNetModType(modificationType)) {
            throw new OseeStateException("    modType [%s] != [%s]", new Object[]{modificationType, this.netModType});
        }
    }

    private boolean netTxCurrentNeedsUpdate(TxChange txCurrent) {
        if (txCurrent == this.netTxCurrent) {
            return false;
        }
        boolean needsUpdate = txCurrent == TxChange.NOT_CURRENT;
        return (needsUpdate |= txCurrent == TxChange.CURRENT && this.netTxCurrent.isDeleted()) || this.netTxCurrent == TxChange.DELETED && txCurrent == TxChange.ARTIFACT_DELETED;
    }

    private boolean netModTypeNeedsUpdate(ModificationType modificationType) {
        boolean needsUpdate = !modificationType.isDeleted() && this.netModType.isDeleted();
        return (needsUpdate |= this.netModType == ModificationType.NEW && modificationType == ModificationType.MODIFIED) || this.netModType == ModificationType.DELETED && modificationType == ModificationType.ARTIFACT_DELETED;
    }

    private boolean ignoreNetModType(ModificationType modificationType) {
        boolean ignore = !this.netModType.isDeleted() && modificationType.isDeleted();
        ignore |= this.netModType == modificationType;
        ignore |= this.netModType == ModificationType.MODIFIED && modificationType == ModificationType.NEW;
        return (ignore |= this.netModType == ModificationType.INTRODUCED && modificationType == ModificationType.NEW) || this.netModType == ModificationType.ARTIFACT_DELETED && modificationType == ModificationType.DELETED;
    }

    private void updateGammas() throws OseeCoreException {
        this.console.writeln("Number of txs rows deleted: [%s]", new Object[]{this.getJdbcClient().runBatchUpdate(this.connection, DELETE_TXS, this.addressingToDelete)});
        this.console.writeln("Number of relation rows deleted: [%s]", new Object[]{this.getJdbcClient().runBatchUpdate(this.connection, DELETE_RELATIONS, this.relationDeleteData)});
        this.console.writeln("Number of txs rows updated: [%s]", new Object[]{this.getJdbcClient().runBatchUpdate(this.connection, UPDATE_TXS_GAMMAS, this.updateAddressingData)});
    }

    private void writeAddressingBackup(long obsoleteGammaId, long transactionId, long netGammaId, int modType, TxChange txCurrent) {
        StringBuilder strB = new StringBuilder(30);
        strB.append(obsoleteGammaId);
        strB.append(",");
        strB.append(transactionId);
        strB.append(",");
        strB.append(netGammaId);
        strB.append(",");
        strB.append(modType);
        strB.append(",");
        strB.append(txCurrent.getValue());
        strB.append("\n");
        this.console.writeln((Object)strB.toString());
    }

    private boolean isNextConceptualRelation(long relationTypeId, int artifactAId, int artiafctBId) {
        return this.previousRelationTypeId != relationTypeId || this.previousArtifactAId != artifactAId || this.previousArtiafctBId != artiafctBId;
    }

    private void relationMateriallyDiffers(JdbcStatement chStmt) throws OseeCoreException {
        if (!this.materiallyDifferent) {
            String currentRationale = chStmt.getString("rationale");
            this.materiallyDifferent |= Strings.isValid((String)currentRationale) && !currentRationale.equals(this.netRationale);
        }
    }

    private void initNextConceptualRelation(long relationTypeId, int artifactAId, int artiafctBId) throws OseeCoreException {
        this.obsoleteGammas.clear();
        this.previousRelationTypeId = relationTypeId;
        this.previousArtifactAId = artifactAId;
        this.previousArtiafctBId = artiafctBId;
        this.netGamma = this.chStmt.getInt("gamma_id");
        this.netRationale = this.chStmt.getString("rationale");
        this.materiallyDifferent = false;
    }
}

