/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.List;
import org.eclipse.osee.executor.admin.HasCancellation;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.data.TransactionTokenDelta;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.change.AddSyntheticArtifactChangeData;
import org.eclipse.osee.orcs.db.internal.change.ComputeNetChangeCallable;
import org.eclipse.osee.orcs.db.internal.change.LoadDeltasBetweenBranches;
import org.eclipse.osee.orcs.db.internal.change.LoadDeltasBetweenTxsOnTheSameBranch;
import org.eclipse.osee.orcs.db.internal.change.MissingChangeItemFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;

public class CompareDatabaseCallable
extends AbstractDatastoreCallable<List<ChangeItem>> {
    private final SqlJoinFactory joinFactory;
    private final TransactionToken sourceTx;
    private final TransactionToken destinationTx;
    private final MissingChangeItemFactory missingChangeItemFactory;
    private final ApplicabilityQuery applicQuery;
    private static final String SELECT_MERGE_BRANCH_UUID = "select merge_branch_id from osee_merge where source_branch_id = ? and dest_branch_id = ?";
    private static final String SELECT_MERGE_BRANCH_HEAD_TX = "select max(transaction_id) from osee_tx_details where branch_id = ?";

    public CompareDatabaseCallable(Log logger, OrcsSession session, JdbcClient service, SqlJoinFactory joinFactory, TransactionToken sourceTx, TransactionToken destinationTx, MissingChangeItemFactory missingChangeItemFactory, ApplicabilityQuery applicQuery) {
        super(logger, session, service);
        this.joinFactory = joinFactory;
        this.sourceTx = sourceTx;
        this.destinationTx = destinationTx;
        this.missingChangeItemFactory = missingChangeItemFactory;
        this.applicQuery = applicQuery;
    }

    public List<ChangeItem> call() throws Exception {
        AbstractDatastoreCallable callable;
        TransactionTokenDelta txDelta = new TransactionTokenDelta(this.sourceTx, this.destinationTx);
        if (txDelta.areOnTheSameBranch()) {
            callable = new LoadDeltasBetweenTxsOnTheSameBranch(this.getLogger(), this.getSession(), this.getJdbcClient(), this.joinFactory, txDelta, this.applicQuery);
        } else {
            BranchId mergeBranch = (BranchId)this.getJdbcClient().fetch((Object)BranchId.SENTINEL, SELECT_MERGE_BRANCH_UUID, new Object[]{this.sourceTx.getBranch(), this.destinationTx.getBranch()});
            TransactionId mergeTx = TransactionId.SENTINEL;
            if (mergeBranch.isValid()) {
                mergeTx = (TransactionId)this.getJdbcClient().fetch((Object)TransactionId.SENTINEL, SELECT_MERGE_BRANCH_HEAD_TX, new Object[]{mergeBranch});
            }
            callable = new LoadDeltasBetweenBranches(this.getLogger(), this.getSession(), this.getJdbcClient(), this.joinFactory, this.sourceTx.getBranch(), this.destinationTx.getBranch(), (TransactionId)this.destinationTx, mergeBranch, mergeTx, this.applicQuery);
        }
        List changes = (List)this.callAndCheckForCancel(callable);
        changes.addAll(this.missingChangeItemFactory.createMissingChanges((HasCancellation)this, this.getSession(), changes, this.sourceTx, this.destinationTx, this.applicQuery));
        ComputeNetChangeCallable computeChanges = new ComputeNetChangeCallable(changes);
        changes = (List)this.callAndCheckForCancel(computeChanges);
        AddSyntheticArtifactChangeData addArtifactData = new AddSyntheticArtifactChangeData(changes);
        return addArtifactData.doWork();
    }
}

