/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.time.GlobalTime;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.accessor.UpdatePreviousTxCurrent;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class CommitBranchDatabaseTxCallable
extends AbstractDatastoreTxCallable<TransactionId> {
    private static final String COMMIT_COMMENT = "Commit Branch ";
    private static final String INSERT_COMMIT_TRANSACTION = "insert into osee_tx_details(tx_type, branch_id, transaction_id, osee_comment, time, author, commit_art_id, build_id) values(?,?,?,?,?,?,?,?)";
    private static final String INSERT_COMMIT_ADDRESSING = "insert into osee_txs(transaction_id, branch_id, gamma_id, mod_type, tx_current, app_id) values(?,?,?,?,?,?)";
    private static final String UPDATE_CONFLICT_STATUS = "update osee_conflict SET status = ? WHERE status = ? AND merge_branch_id = ?";
    private static final String UPDATE_MERGE_COMMIT_TX = "update osee_merge set commit_transaction_id = ? Where source_branch_id = ? and dest_branch_id = ?";
    private static final String SELECT_SOURCE_BRANCH_STATE = "select (1) from osee_branch where branch_id=? and branch_state=?";
    private static final String UPDATE_SOURCE_BRANCH_STATE = "update osee_branch set branch_state=? where branch_id=?";
    private final SqlJoinFactory joinFactory;
    private final IdentityManager idManager;
    private final ArtifactId committer;
    private final BranchReadable sourceBranch;
    private final BranchReadable destinationBranch;
    private final BranchId mergeBranch;
    private final List<ChangeItem> changes;
    private final Long buildVersionId;

    public CommitBranchDatabaseTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, SqlJoinFactory joinFactory, IdentityManager idManager, ArtifactId committer, BranchReadable sourceBranch, BranchReadable destinationBranch, BranchId mergeBranch, List<ChangeItem> changes, Long buildVersionId) {
        super(logger, session, jdbcClient);
        this.joinFactory = joinFactory;
        this.idManager = idManager;
        this.committer = committer;
        this.sourceBranch = sourceBranch;
        this.destinationBranch = destinationBranch;
        this.mergeBranch = mergeBranch;
        this.changes = changes;
        this.buildVersionId = buildVersionId;
    }

    @Override
    protected TransactionId handleTxWork(JdbcConnection connection) throws OseeCoreException {
        if (this.changes.isEmpty()) {
            throw new OseeStateException("A branch can not be committed without any changes made.", new Object[0]);
        }
        BranchState storedBranchState = this.sourceBranch.getBranchState();
        this.checkPreconditions();
        TransactionId newTx = null;
        try {
            newTx = this.addCommitTransactionToDatabase(this.committer, connection);
            this.updatePreviousCurrentsOnDestinationBranch(connection);
            this.insertCommitAddressing(newTx, connection);
            this.getJdbcClient().runPreparedUpdate(connection, UPDATE_MERGE_COMMIT_TX, new Object[]{newTx, this.sourceBranch, this.destinationBranch});
            this.manageBranchStates();
            if (this.mergeBranch.isValid()) {
                this.getJdbcClient().runPreparedUpdate(UPDATE_CONFLICT_STATUS, new Object[]{ConflictStatus.COMMITTED.getValue(), ConflictStatus.RESOLVED.getValue(), this.mergeBranch});
            }
        }
        catch (OseeCoreException ex) {
            this.updateBranchState(storedBranchState, (BranchId)this.sourceBranch);
            throw ex;
        }
        return newTx;
    }

    public synchronized void checkPreconditions() throws OseeCoreException {
        int count = (Integer)this.getJdbcClient().fetch((Object)0, SELECT_SOURCE_BRANCH_STATE, new Object[]{this.sourceBranch, BranchState.COMMIT_IN_PROGRESS.getValue()});
        if (this.sourceBranch.getBranchState().isCommitInProgress() || this.sourceBranch.getArchiveState().isArchived() || count > 0) {
            throw new OseeStateException("Commit completed or in progress for [%s]", new Object[]{this.sourceBranch});
        }
        if (!this.sourceBranch.getBranchState().equals((Object)BranchState.COMMITTED)) {
            this.updateBranchState(BranchState.COMMIT_IN_PROGRESS, (BranchId)this.sourceBranch);
        }
    }

    public void updateBranchState(BranchState state, BranchId branchId) throws OseeCoreException {
        this.getJdbcClient().runPreparedUpdate(UPDATE_SOURCE_BRANCH_STATE, new Object[]{state.getValue(), branchId});
    }

    private void updatePreviousCurrentsOnDestinationBranch(JdbcConnection connection) throws OseeCoreException {
        UpdatePreviousTxCurrent updater = new UpdatePreviousTxCurrent(this.getJdbcClient(), this.joinFactory, connection, (BranchId)this.destinationBranch);
        for (ChangeItem change : this.changes) {
            switch (change.getChangeType()) {
                case ARTIFACT_CHANGE: {
                    updater.addArtifact(change.getItemId());
                    break;
                }
                case ATTRIBUTE_CHANGE: {
                    updater.addAttribute(change.getItemId());
                    break;
                }
                case RELATION_CHANGE: {
                    updater.addRelation(change.getItemId());
                    break;
                }
                case TUPLE_CHANGE: {
                    updater.addTuple((Id)change.getCurrentVersion().getGammaId());
                    break;
                }
                default: {
                    throw new OseeStateException("Unexpected change type", new Object[0]);
                }
            }
        }
        updater.updateTxNotCurrents();
    }

    private TransactionId addCommitTransactionToDatabase(ArtifactId committer, JdbcConnection connection) throws OseeCoreException {
        TransactionId newTransactionNumber = this.idManager.getNextTransactionId();
        Timestamp timestamp = GlobalTime.GreenwichMeanTimestamp();
        String comment = COMMIT_COMMENT + this.sourceBranch.getName();
        this.getJdbcClient().runPreparedUpdate(connection, INSERT_COMMIT_TRANSACTION, new Object[]{TransactionDetailsType.NonBaselined.getId(), this.destinationBranch, newTransactionNumber, comment, timestamp, committer, this.sourceBranch.getAssociatedArtifact(), this.buildVersionId});
        return newTransactionNumber;
    }

    private void insertCommitAddressing(TransactionId newTx, JdbcConnection connection) throws OseeCoreException {
        ArrayList<Object[]> insertData = new ArrayList<Object[]>();
        for (ChangeItem change : this.changes) {
            ModificationType modType = change.getNetChange().getModType();
            ApplicabilityToken appToken = change.getNetChange().getApplicabilityToken();
            insertData.add(new Object[]{newTx, this.destinationBranch, change.getNetChange().getGammaId(), modType.getValue(), TxChange.getCurrent((ModificationType)modType).getValue(), appToken});
        }
        this.getJdbcClient().runBatchUpdate(connection, INSERT_COMMIT_ADDRESSING, insertData);
    }

    private void manageBranchStates() throws OseeCoreException {
        this.updateBranchState(BranchState.MODIFIED, (BranchId)this.destinationBranch);
        BranchState sourceBranchState = this.sourceBranch.getBranchState();
        if (!(sourceBranchState.isCreationInProgress() || sourceBranchState.isRebaselined() || sourceBranchState.isRebaselineInProgress() || sourceBranchState.isCommitted())) {
            this.updateBranchState(BranchState.COMMITTED, (BranchId)this.sourceBranch);
        }
        if (this.mergeBranch.isValid()) {
            this.updateBranchState(BranchState.COMMITTED, this.mergeBranch);
        }
    }
}

