/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.executor.admin.HasCancellation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.model.change.ChangeIgnoreType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.callable.CommitBranchDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.change.ComputeNetChangeCallable;
import org.eclipse.osee.orcs.db.internal.change.LoadDeltasBetweenBranches;
import org.eclipse.osee.orcs.db.internal.change.MissingChangeItemFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;

public class CommitBranchDatabaseCallable
extends AbstractDatastoreCallable<TransactionId> {
    private final SqlJoinFactory joinFactory;
    private final IdentityManager idManager;
    private final ArtifactId committer;
    private final TransactionToken sourceHead;
    private final BranchReadable source;
    private final TransactionToken destinationHead;
    private final BranchReadable destination;
    private final MissingChangeItemFactory missingChangeItemFactory;
    private final ApplicabilityQuery applicQuery;
    private static final String SELECT_MERGE_BRANCH_UUID = "select merge_branch_id from osee_merge where source_branch_id = ? and dest_branch_id = ?";
    private static final String SELECT_MERGE_BRANCH_HEAD_TX = "select max(transaction_id) from osee_tx_details where branch_id = ?";

    public CommitBranchDatabaseCallable(Log logger, OrcsSession session, JdbcClient service, SqlJoinFactory joinFactory, IdentityManager idManager, ArtifactId committer, BranchReadable source, TransactionToken sourceHead, BranchReadable destination, TransactionToken destinationHead, MissingChangeItemFactory missingChangeItemFactory, ApplicabilityQuery applicQuery) {
        super(logger, session, service);
        this.joinFactory = joinFactory;
        this.idManager = idManager;
        this.committer = committer;
        this.source = source;
        this.sourceHead = sourceHead;
        this.destination = destination;
        this.destinationHead = destinationHead;
        this.missingChangeItemFactory = missingChangeItemFactory;
        this.applicQuery = applicQuery;
    }

    private List<ChangeItem> callComputeChanges(BranchId mergeBranch) throws Exception {
        TransactionId mergeTxId = (TransactionId)this.getJdbcClient().fetch((Object)TransactionId.SENTINEL, SELECT_MERGE_BRANCH_HEAD_TX, new Object[]{mergeBranch});
        LoadDeltasBetweenBranches loadChanges = new LoadDeltasBetweenBranches(this.getLogger(), this.getSession(), this.getJdbcClient(), this.joinFactory, this.sourceHead.getBranch(), this.destinationHead.getBranch(), (TransactionId)this.destinationHead, mergeBranch, mergeTxId, this.applicQuery);
        List changes = (List)this.callAndCheckForCancel(loadChanges);
        changes.addAll(this.missingChangeItemFactory.createMissingChanges((HasCancellation)this, this.getSession(), changes, this.sourceHead, this.destinationHead, this.applicQuery));
        ComputeNetChangeCallable computeChanges = new ComputeNetChangeCallable(changes);
        ArrayList<ChangeItem> computedChanges = new ArrayList<ChangeItem>();
        for (ChangeItem item : (List)this.callAndCheckForCancel(computeChanges)) {
            if (!this.isAllowableChange(item.getIgnoreType())) continue;
            computedChanges.add(item);
        }
        return computedChanges;
    }

    private boolean isAllowableChange(ChangeIgnoreType type) {
        return type.isNone() || type.isResurrected();
    }

    public TransactionId call() throws Exception {
        BranchId mergeBranch = (BranchId)this.getJdbcClient().fetch((Object)BranchId.SENTINEL, SELECT_MERGE_BRANCH_UUID, new Object[]{this.source, this.destination});
        List<ChangeItem> changes = this.callComputeChanges(mergeBranch);
        CommitBranchDatabaseTxCallable commitCallable = new CommitBranchDatabaseTxCallable(this.getLogger(), this.getSession(), this.getJdbcClient(), this.joinFactory, this.idManager, this.committer, this.source, this.destination, mergeBranch, changes, OseeCodeVersion.getVersionId());
        TransactionId newTx = (TransactionId)this.callAndCheckForCancel(commitCallable);
        return newTx;
    }
}

