/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.time.GlobalTime;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.accessor.UpdatePreviousTxCurrent;
import org.eclipse.osee.orcs.db.internal.callable.CreateBranchDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public final class BranchCopyTxCallable
extends JdbcTransaction {
    private final CreateBranchData branchData;
    private static final String INSERT_TX_DETAILS = "INSERT INTO osee_tx_details (branch_id, transaction_id, osee_comment, time, author, tx_type, build_id) VALUES (?,?,?,?,?,?,?)";
    private static final String INSERT_ADDRESSING = "INSERT INTO osee_txs (transaction_id, gamma_id, mod_type, tx_current, branch_id, app_id) VALUES (?,?,?,?,?,?)";
    private static final String SELECT_ADDRESSING = "SELECT gamma_id, mod_type, app_id FROM osee_txs txs WHERE txs.branch_id = ? AND txs.transaction_id = ?";
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;
    private final IdentityManager idManager;
    private final Long buildVersionId;

    public BranchCopyTxCallable(JdbcClient jdbcClient, SqlJoinFactory joinFactory, IdentityManager idManager, CreateBranchData branchData, Long buildVersionId) {
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.branchData = branchData;
        this.idManager = idManager;
        this.buildVersionId = buildVersionId;
    }

    public void handleTxWork(JdbcConnection connection) {
        new CreateBranchDatabaseTxCallable(this.jdbcClient, this.idManager, this.branchData, this.buildVersionId).handleTxWork(connection);
        Timestamp timestamp = GlobalTime.GreenwichMeanTimestamp();
        TransactionId nextTransactionId = this.idManager.getNextTransactionId();
        String creationComment = this.branchData.getCreationComment();
        this.jdbcClient.runPreparedUpdate(connection, INSERT_TX_DETAILS, new Object[]{this.branchData.getBranch(), nextTransactionId, creationComment, timestamp, this.branchData.getAuthor(), TransactionDetailsType.NonBaselined.getId(), OseeCodeVersion.getVersionId()});
        this.populateTransaction(0.3, connection, nextTransactionId, this.branchData.getParentBranch(), this.branchData.getSavedTransaction());
        UpdatePreviousTxCurrent updater = new UpdatePreviousTxCurrent(this.jdbcClient, this.joinFactory, connection, this.branchData.getBranch());
        updater.updateTxNotCurrentsFromTx(nextTransactionId);
    }

    private void populateTransaction(double workAmount, JdbcConnection connection, TransactionId intoTx, BranchId parentBranch, TransactionId copyTxId) throws OseeCoreException {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        HashSet<Long> gammas = new HashSet<Long>(100000);
        this.populateAddressingToCopy(connection, data, intoTx, gammas, SELECT_ADDRESSING, parentBranch, copyTxId);
        if (!data.isEmpty()) {
            this.jdbcClient.runBatchUpdate(connection, INSERT_ADDRESSING, data);
        }
    }

    private void populateAddressingToCopy(JdbcConnection connection, List<Object[]> data, TransactionId baseTxId, HashSet<Long> gammas, String query, Object ... parameters) throws OseeCoreException {
        try (JdbcStatement chStmt = this.jdbcClient.getStatement(connection);){
            chStmt.runPreparedQuery(10000, query, parameters);
            while (chStmt.next()) {
                Long gamma = chStmt.getLong("gamma_id");
                if (gammas.contains(gamma)) continue;
                ModificationType modType = ModificationType.getMod((int)chStmt.getInt("mod_type"));
                Long app_id = chStmt.getLong("app_id");
                TxChange txCurrent = TxChange.getCurrent((ModificationType)modType);
                data.add(new Object[]{baseTxId, gamma, modType.getValue(), txCurrent.getValue(), this.branchData.getBranch(), app_id});
                gammas.add(gamma);
            }
        }
    }
}

