/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;

public abstract class AbstractDatastoreTxCallable<T>
extends AbstractDatastoreCallable<T> {
    protected AbstractDatastoreTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient) {
        super(logger, session, jdbcClient);
    }

    public final T call() throws Exception {
        T value = null;
        this.onExecutionStart();
        try {
            InternalTxWork work = new InternalTxWork();
            this.getJdbcClient().runTransaction((JdbcTransaction)work);
            value = work.getResult();
        }
        finally {
            this.onExecutionComplete();
        }
        return value;
    }

    protected void onExecutionStart() {
    }

    protected void onExecutionComplete() {
    }

    protected abstract T handleTxWork(JdbcConnection var1) throws OseeCoreException;

    protected void handleTxException(Exception ex) {
    }

    protected void handleTxFinally() throws OseeCoreException {
    }

    private final class InternalTxWork
    extends JdbcTransaction {
        private T result;

        private InternalTxWork() {
        }

        public T getResult() {
            return this.result;
        }

        public void handleTxWork(JdbcConnection connection) throws OseeCoreException {
            this.result = AbstractDatastoreTxCallable.this.handleTxWork(connection);
        }

        public void handleTxException(Exception ex) {
            AbstractDatastoreTxCallable.this.handleTxException(ex);
        }

        public void handleTxFinally() throws OseeCoreException {
            AbstractDatastoreTxCallable.this.handleTxFinally();
        }
    }
}

