/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.concurrent.Callable;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;

public abstract class AbstractDatastoreCallable<T>
extends CancellableCallable<T> {
    private final OrcsSession session;
    private final JdbcClient jdbcClient;
    private final Log logger;
    private Callable<?> innerWorker;

    protected AbstractDatastoreCallable(Log logger, OrcsSession session, JdbcClient jdbcClient) {
        this.logger = logger;
        this.session = session;
        this.jdbcClient = jdbcClient;
    }

    protected OrcsSession getSession() {
        return this.session;
    }

    protected JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected <K> K callAndCheckForCancel(Callable<K> callable) throws Exception {
        this.checkForCancelled();
        this.setInnerWorker(callable);
        K result = callable.call();
        this.setInnerWorker(null);
        return result;
    }

    private synchronized void setInnerWorker(Callable<?> callable) {
        this.innerWorker = callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancel(boolean isCancelled) {
        super.setCancel(isCancelled);
        Callable<?> inner = this.innerWorker;
        if (inner != null) {
            Callable<?> callable = inner;
            synchronized (callable) {
                if (inner instanceof CancellableCallable) {
                    ((CancellableCallable)inner).setCancel(isCancelled);
                }
            }
        }
    }
}

