/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.branch;

import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.executor.admin.ExecutorAdmin;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.data.ArchiveOperation;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.ArchiveUnarchiveBranchCallable;
import org.eclipse.osee.orcs.db.internal.callable.BranchCopyTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.ChangeBranchFieldCallable;
import org.eclipse.osee.orcs.db.internal.callable.CheckBranchExchangeIntegrityCallable;
import org.eclipse.osee.orcs.db.internal.callable.CommitBranchDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.callable.CompareDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.callable.CompositeDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.CreateBranchDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.ExportBranchDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.callable.ImportBranchDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.callable.PurgeBranchDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.change.MissingChangeItemFactoryImpl;
import org.eclipse.osee.orcs.db.internal.exchange.ExportItemFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;

public class BranchModule {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;
    private final IdentityManager idManager;
    private final SystemPreferences preferences;
    private final ExecutorAdmin executorAdmin;
    private final IResourceManager resourceManager;

    public BranchModule(Log logger, JdbcClient jdbcClient, SqlJoinFactory joinFactory, IdentityManager idManager, SystemPreferences preferences, ExecutorAdmin executorAdmin, IResourceManager resourceManager) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.idManager = idManager;
        this.preferences = preferences;
        this.executorAdmin = executorAdmin;
        this.resourceManager = resourceManager;
    }

    public BranchDataStore createBranchDataStore(DataLoaderFactory dataLoaderFactory) {
        final MissingChangeItemFactoryImpl missingChangeItemFactory = new MissingChangeItemFactoryImpl(dataLoaderFactory);
        return new BranchDataStore(){

            public void createBranch(CreateBranchData branchData) {
                BranchModule.this.jdbcClient.runTransaction((JdbcTransaction)new CreateBranchDatabaseTxCallable(BranchModule.this.jdbcClient, BranchModule.this.idManager, branchData, OseeCodeVersion.getVersionId()));
            }

            public void createBranchCopyTx(CreateBranchData branchData) {
                BranchModule.this.jdbcClient.runTransaction((JdbcTransaction)new BranchCopyTxCallable(BranchModule.this.jdbcClient, BranchModule.this.joinFactory, BranchModule.this.idManager, branchData, OseeCodeVersion.getVersionId()));
            }

            public Callable<TransactionId> commitBranch(OrcsSession session, ArtifactId committer, BranchReadable source, TransactionToken sourceHead, BranchReadable destination, TransactionToken destinationHead, ApplicabilityQuery applicQuery) {
                return new CommitBranchDatabaseCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, BranchModule.this.joinFactory, BranchModule.this.idManager, committer, source, sourceHead, destination, destinationHead, missingChangeItemFactory, applicQuery);
            }

            public Callable<Void> purgeBranch(OrcsSession session, BranchReadable toDelete) {
                return new PurgeBranchDatabaseCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, toDelete);
            }

            public Callable<List<ChangeItem>> compareBranch(OrcsSession session, TransactionToken sourceTx, TransactionToken destinationTx, ApplicabilityQuery applicQuery) {
                return new CompareDatabaseCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, BranchModule.this.joinFactory, sourceTx, destinationTx, missingChangeItemFactory, applicQuery);
            }

            public Callable<URI> exportBranch(OrcsSession session, OrcsTypes orcsTypes, List<? extends BranchId> branches, PropertyStore options, String exportName) {
                ExportItemFactory factory = new ExportItemFactory(BranchModule.this.logger, BranchModule.this.preferences, BranchModule.this.jdbcClient, BranchModule.this.resourceManager, orcsTypes);
                return new ExportBranchDatabaseCallable(session, factory, BranchModule.this.joinFactory, BranchModule.this.preferences, BranchModule.this.executorAdmin, branches, options, exportName);
            }

            public Callable<URI> importBranch(OrcsSession session, OrcsTypes orcsTypes, URI fileToImport, List<? extends BranchId> branches, PropertyStore options) {
                ImportBranchDatabaseCallable callable = new ImportBranchDatabaseCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, BranchModule.this.preferences, BranchModule.this.resourceManager, BranchModule.this.idManager, orcsTypes, fileToImport, branches, options);
                return callable;
            }

            public Callable<URI> checkBranchExchangeIntegrity(OrcsSession session, URI fileToCheck) {
                return new CheckBranchExchangeIntegrityCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, BranchModule.this.preferences, BranchModule.this.resourceManager, fileToCheck);
            }

            public Callable<Void> changeBranchState(OrcsSession session, BranchId branch, BranchState branchState) {
                return ChangeBranchFieldCallable.newBranchState(BranchModule.this.logger, session, BranchModule.this.jdbcClient, branch, branchState);
            }

            public Callable<Void> changeBranchType(OrcsSession session, BranchId branch, BranchType branchType) {
                return ChangeBranchFieldCallable.newBranchType(BranchModule.this.logger, session, BranchModule.this.jdbcClient, branch, branchType);
            }

            public Callable<Void> changeBranchName(OrcsSession session, BranchId branch, String branchName) {
                return ChangeBranchFieldCallable.newBranchName(BranchModule.this.logger, session, BranchModule.this.jdbcClient, branch, branchName);
            }

            public Callable<Void> changeBranchAssociatedArt(OrcsSession session, BranchId branch, ArtifactId assocArt) {
                return ChangeBranchFieldCallable.newAssocArtId(BranchModule.this.logger, session, BranchModule.this.jdbcClient, branch, assocArt);
            }

            public Callable<Void> archiveUnArchiveBranch(OrcsSession session, BranchId branch, ArchiveOperation op) {
                return new ArchiveUnarchiveBranchCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, branch, op);
            }

            public Callable<Void> deleteBranch(OrcsSession session, BranchId branch) {
                AbstractDatastoreTxCallable deleteBranch = (AbstractDatastoreTxCallable)((Object)this.changeBranchState(session, branch, BranchState.DELETED));
                AbstractDatastoreTxCallable archiveBranch = (AbstractDatastoreTxCallable)((Object)this.archiveUnArchiveBranch(session, branch, ArchiveOperation.ARCHIVE));
                CompositeDatastoreTxCallable composite = new CompositeDatastoreTxCallable(BranchModule.this.logger, session, BranchModule.this.jdbcClient, deleteBranch, archiveBranch);
                return composite;
            }
        };
    }
}

