/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.accessor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class UpdatePreviousTxCurrent {
    private static final String UPDATE_TXS_NOT_CURRENT = "update osee_txs SET tx_current = " + TxChange.NOT_CURRENT.getValue() + " where branch_id = ? AND gamma_id = ? and transaction_id = ?";
    private static final String UPDATE_TXS_NOT_CURRENT_NO_TX = "update osee_txs SET tx_current = " + TxChange.NOT_CURRENT.getValue() + " where branch_id = ? AND gamma_id = ?";
    private static final String SELECT_TXS_AND_GAMMAS = "SELECT txs.transaction_id, txs.gamma_id FROM osee_join_id idj, %s item, osee_txs txs WHERE idj.query_id = ? and idj.id = item.%s AND item.gamma_id = txs.gamma_id AND txs.branch_id = ? AND txs.tx_current <> ?";
    private static final String SELECT_TXS_AND_GAMMAS_FROM_TXS = "with\ntxs as (select gamma_id from osee_txs where branch_id = ? and transaction_id = ?),\nitem as (\n   SELECT item2.gamma_id FROM osee_attribute item1, txs, osee_attribute item2 where txs.gamma_id = item1.gamma_id and item1.attr_id = item2.attr_id\nUNION ALL\n   SELECT item2.gamma_id FROM osee_artifact item1, txs, osee_artifact item2 where txs.gamma_id = item1.gamma_id and item1.art_id = item2.art_id\nUNION ALL\n   SELECT item2.gamma_id FROM osee_relation_link item1, txs, osee_relation_link item2 where txs.gamma_id = item1.gamma_id and item1.rel_link_id = item2.rel_link_id)\nselect txsb.transaction_id, txsb.gamma_id FROM item, osee_txs txsb where item.gamma_id = txsb.gamma_id AND txsb.branch_id = ? AND transaction_id <> ? AND txsb.tx_current <> ?";
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;
    private final BranchId branch;
    private final JdbcConnection connection;
    private IdJoinQuery artifactJoin;
    private IdJoinQuery attributeJoin;
    private IdJoinQuery relationJoin;
    private List<Long> tuplesToUpdate;

    public UpdatePreviousTxCurrent(JdbcClient jdbcClient, SqlJoinFactory joinFactory, JdbcConnection connection, BranchId branch) {
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.branch = branch;
        this.connection = connection;
    }

    public void addAttribute(Id attributeId) {
        if (this.attributeJoin == null) {
            this.attributeJoin = this.joinFactory.createIdJoinQuery();
        }
        this.attributeJoin.add(attributeId.getId());
    }

    public void addArtifact(Id artifactId) {
        if (this.artifactJoin == null) {
            this.artifactJoin = this.joinFactory.createIdJoinQuery();
        }
        this.artifactJoin.add(artifactId.getId());
    }

    public void addRelation(Id relationId) {
        if (this.relationJoin == null) {
            this.relationJoin = this.joinFactory.createIdJoinQuery();
        }
        this.relationJoin.add(relationId.getId());
    }

    public void addTuple(Id tupleId) {
        if (this.tuplesToUpdate == null) {
            this.tuplesToUpdate = new ArrayList<Long>();
        }
        this.tuplesToUpdate.add(tupleId.getId());
    }

    public void updateTxNotCurrents() throws OseeCoreException {
        this.updateTxNotCurrents("osee_artifact", "art_id", this.artifactJoin);
        this.updateTxNotCurrents("osee_attribute", "attr_id", this.attributeJoin);
        this.updateTxNotCurrents("osee_relation_link", "rel_link_id", this.relationJoin);
        this.updateTxNotCurrentsTuple("osee_tuple2", "e1", this.tuplesToUpdate);
    }

    private void updateTxNotCurrentsTuple(String tableName, String columnName, List<Long> tuplesToUpdate) throws OseeCoreException {
        if (tuplesToUpdate != null) {
            ArrayList<Object[]> updateData = new ArrayList<Object[]>();
            for (Long tuple : tuplesToUpdate) {
                updateData.add(new Object[]{this.branch, tuple});
            }
            this.jdbcClient.runBatchUpdate(this.connection, UPDATE_TXS_NOT_CURRENT_NO_TX, updateData);
        }
    }

    private void updateTxNotCurrents(String tableName, String columnName, IdJoinQuery idJoin) throws OseeCoreException {
        if (idJoin != null) {
            idJoin.store(this.connection);
            this.updateNoLongerCurrentGammas(tableName, columnName, idJoin.getQueryId());
            idJoin.delete(this.connection);
        }
    }

    private void updateNoLongerCurrentGammas(String tableName, String columnName, int queryId) throws OseeCoreException {
        String query = String.format(SELECT_TXS_AND_GAMMAS, tableName, columnName);
        ArrayList<Object[]> updateData = new ArrayList<Object[]>();
        try (JdbcStatement chStmt = this.jdbcClient.getStatement(this.connection);){
            chStmt.runPreparedQuery(10000, query, new Object[]{queryId, this.branch, TxChange.NOT_CURRENT.getValue()});
            while (chStmt.next()) {
                updateData.add(new Object[]{this.branch, chStmt.getLong("gamma_id"), chStmt.getLong("transaction_id")});
            }
        }
        this.jdbcClient.runBatchUpdate(this.connection, UPDATE_TXS_NOT_CURRENT, updateData);
    }

    public void updateTxNotCurrentsFromTx(TransactionId transaction_id) throws OseeCoreException {
        ArrayList<Object[]> updateData = new ArrayList<Object[]>();
        try (JdbcStatement chStmt = this.jdbcClient.getStatement(this.connection);){
            chStmt.runPreparedQuery(10000, SELECT_TXS_AND_GAMMAS_FROM_TXS, new Object[]{this.branch, transaction_id, this.branch, transaction_id, TxChange.NOT_CURRENT.getValue()});
            while (chStmt.next()) {
                updateData.add(new Object[]{this.branch, chStmt.getLong("gamma_id"), chStmt.getLong("transaction_id")});
            }
        }
        this.jdbcClient.runBatchUpdate(this.connection, UPDATE_TXS_NOT_CURRENT, updateData);
    }
}

