/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal;

import org.eclipse.osee.executor.admin.ExecutorAdmin;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.core.ds.DataModule;
import org.eclipse.osee.orcs.core.ds.OrcsDataStore;
import org.eclipse.osee.orcs.core.ds.OrcsTypesDataStore;
import org.eclipse.osee.orcs.core.ds.QueryEngineIndexer;
import org.eclipse.osee.orcs.db.internal.AdminModule;
import org.eclipse.osee.orcs.db.internal.DataModuleFactory;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.branch.BranchModule;
import org.eclipse.osee.orcs.db.internal.branch.KeyValueModule;
import org.eclipse.osee.orcs.db.internal.loader.DataProxyFactoryProvider;
import org.eclipse.osee.orcs.db.internal.loader.LoaderModule;
import org.eclipse.osee.orcs.db.internal.search.QueryModule;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.db.internal.transaction.TxModule;
import org.eclipse.osee.orcs.db.internal.types.TypesModule;
import org.eclipse.osee.orcs.db.internal.util.IdentityManagerImpl;
import org.osgi.framework.BundleContext;

public class OrcsDataStoreImpl
implements OrcsDataStore {
    private Log logger;
    private JdbcService jdbcService;
    private SystemPreferences preferences;
    private ExecutorAdmin executorAdmin;
    private IResourceManager resourceManager;
    private DataProxyFactoryProvider proxyProvider;
    private OrcsTypesDataStore typesDataStore;
    private DataModuleFactory dataModuleFactory;
    private QueryModule queryModule;
    private IdentityManager idManager;
    private SqlJoinFactory joinFactory;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    public void setResourceManager(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setSystemPreferences(SystemPreferences preferences) {
        this.preferences = preferences;
    }

    public void setDataProxyFactoryProvider(DataProxyFactoryProvider proxyProvider) {
        this.proxyProvider = proxyProvider;
    }

    public void setSqlJoinFactory(SqlJoinFactory joinFactory) {
        this.joinFactory = joinFactory;
    }

    public void start(BundleContext context) throws Exception {
        JdbcClient jdbcClient = this.jdbcService.getClient();
        this.idManager = new IdentityManagerImpl(jdbcClient);
        TypesModule typesModule = new TypesModule(this.logger, jdbcClient, this.joinFactory, this.resourceManager);
        this.typesDataStore = typesModule.createTypesDataStore();
        LoaderModule loaderModule = new LoaderModule(this.logger, jdbcClient, this.idManager, this.proxyProvider, this.joinFactory);
        this.queryModule = new QueryModule(this.logger, this.executorAdmin, jdbcClient, this.joinFactory, this.idManager);
        this.queryModule.startIndexer(this.resourceManager);
        BranchModule branchModule = new BranchModule(this.logger, jdbcClient, this.joinFactory, this.idManager, this.preferences, this.executorAdmin, this.resourceManager);
        TxModule txModule = new TxModule(this.logger, jdbcClient, this.joinFactory, this.idManager);
        AdminModule adminModule = new AdminModule(this.logger, jdbcClient, this.idManager, this.preferences, this.typesDataStore);
        KeyValueModule keyValueModule = new KeyValueModule(jdbcClient);
        this.dataModuleFactory = new DataModuleFactory(this.logger, loaderModule, this.queryModule, branchModule, keyValueModule, txModule, adminModule);
    }

    public void stop() throws Exception {
        this.queryModule.stopIndexer();
        this.queryModule = null;
    }

    public OrcsTypesDataStore getTypesDataStore() {
        return this.typesDataStore;
    }

    public DataModule createDataModule(OrcsTypes orcsTypes) {
        return this.dataModuleFactory.createDataModule(orcsTypes);
    }

    public QueryEngineIndexer getQueryEngineIndexer() {
        return this.queryModule.getQueryIndexer();
    }
}

