/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.DataProxyFactory;
import org.eclipse.osee.orcs.db.internal.loader.DataProxyFactoryProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class DataProxyFactoryProviderImpl
implements DataProxyFactoryProvider {
    private final Map<String, DataProxyFactory> proxyClassMap = new ConcurrentHashMap<String, DataProxyFactory>();
    private final List<ServiceReference<DataProxyFactory>> pending = new CopyOnWriteArrayList<ServiceReference<DataProxyFactory>>();
    private Log logger;
    private Thread thread;
    private boolean isReady = false;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void start() {
        this.isReady = true;
        this.thread = new Thread("Register Pending DataProxyFactories"){

            @Override
            public void run() {
                for (ServiceReference reference : DataProxyFactoryProviderImpl.this.pending) {
                    try {
                        DataProxyFactoryProviderImpl.this.register((ServiceReference<DataProxyFactory>)reference);
                    }
                    catch (Throwable ex) {
                        DataProxyFactoryProviderImpl.this.getLogger().error(ex, "Error registering pending data proxy factories", new Object[0]);
                    }
                }
                DataProxyFactoryProviderImpl.this.pending.clear();
            }
        };
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
        this.isReady = false;
    }

    public void addFactory(ServiceReference<DataProxyFactory> reference) throws Exception {
        if (this.isReady) {
            this.register(reference);
        } else {
            this.pending.add(reference);
        }
    }

    public void removeFactory(ServiceReference<DataProxyFactory> reference) throws Exception {
        if (this.isReady) {
            this.unregister(reference);
        } else {
            this.pending.remove(reference);
        }
    }

    private void unregister(ServiceReference<DataProxyFactory> reference) throws OseeCoreException {
        String[] aliases;
        String[] stringArray = aliases = this.getAliases(reference);
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            this.proxyClassMap.remove(alias);
            ++n2;
        }
    }

    private void register(ServiceReference<DataProxyFactory> reference) {
        try {
            String[] aliases;
            Bundle bundle = reference.getBundle();
            DataProxyFactory factory = (DataProxyFactory)bundle.getBundleContext().getService(reference);
            Conditions.checkNotNull((Object)factory, (String)"DataProxyFactory");
            String[] stringArray = aliases = this.getAliases(reference);
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                this.proxyClassMap.put(alias, factory);
                ++n2;
            }
        }
        catch (Throwable th) {
            this.getLogger().error(th, "Error registering data proxy [%s]", new Object[]{reference.getProperty("component.name")});
        }
    }

    private String[] getAliases(ServiceReference<DataProxyFactory> reference) throws OseeCoreException {
        Object value = reference.getProperty("proxy.factory.alias");
        String[] aliases = null;
        if (value instanceof String[]) {
            aliases = (String[])value;
        }
        Conditions.checkNotNull((Object)aliases, (String)"Aliases", (String)"Error getting [%s]", (Object[])new Object[]{"proxy.factory.alias"});
        return aliases;
    }

    @Override
    public DataProxyFactory getFactory(String factoryAlias) {
        return this.proxyClassMap.get(factoryAlias);
    }
}

