/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal;

import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.ds.DataFactory;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.DataModule;
import org.eclipse.osee.orcs.core.ds.DataStoreAdmin;
import org.eclipse.osee.orcs.core.ds.KeyValueStore;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.ds.QueryEngineIndexer;
import org.eclipse.osee.orcs.core.ds.TxDataStore;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.AdminModule;
import org.eclipse.osee.orcs.db.internal.OrcsObjectFactory;
import org.eclipse.osee.orcs.db.internal.branch.BranchModule;
import org.eclipse.osee.orcs.db.internal.branch.KeyValueModule;
import org.eclipse.osee.orcs.db.internal.loader.LoaderModule;
import org.eclipse.osee.orcs.db.internal.loader.ProxyDataFactory;
import org.eclipse.osee.orcs.db.internal.loader.processor.DynamicLoadProcessor;
import org.eclipse.osee.orcs.db.internal.search.QueryModule;
import org.eclipse.osee.orcs.db.internal.transaction.TxModule;

public class DataModuleFactory {
    private final Log logger;
    private final LoaderModule loaderModule;
    private final QueryModule queryModule;
    private final BranchModule branchModule;
    private final KeyValueModule keyValueModule;
    private final TxModule txModule;
    private final AdminModule adminModule;

    public DataModuleFactory(Log logger, LoaderModule loaderModule, QueryModule queryModule, BranchModule branchModule, KeyValueModule keyValueModule, TxModule txModule, AdminModule adminModule) {
        this.logger = logger;
        this.loaderModule = loaderModule;
        this.queryModule = queryModule;
        this.branchModule = branchModule;
        this.keyValueModule = keyValueModule;
        this.txModule = txModule;
        this.adminModule = adminModule;
    }

    public DataModule createDataModule(OrcsTypes orcsTypes) {
        this.logger.debug("Creating DataModule", new Object[0]);
        ArtifactTypes artifactTypes = orcsTypes.getArtifactTypes();
        AttributeTypes attributeTypes = orcsTypes.getAttributeTypes();
        QueryEngineIndexer indexer = this.queryModule.getQueryIndexer();
        ProxyDataFactory proxyFactory = this.loaderModule.createProxyDataFactory(attributeTypes);
        OrcsObjectFactory objectFactory = this.loaderModule.createOrcsObjectFactory(proxyFactory);
        final DataFactory dataFactory = this.loaderModule.createDataFactory(objectFactory, artifactTypes);
        DynamicLoadProcessor loadProcessor = this.loaderModule.createDynamicLoadProcessor(orcsTypes, proxyFactory);
        final DataLoaderFactory dataLoaderFactory = this.loaderModule.createDataLoaderFactory(objectFactory, loadProcessor, attributeTypes);
        final QueryEngine queryEngine = this.queryModule.createQueryEngine(dataLoaderFactory, attributeTypes);
        final BranchDataStore branchDataStore = this.branchModule.createBranchDataStore(dataLoaderFactory);
        final KeyValueStore keyValueStore = this.keyValueModule.createKeyValueStore();
        final TxDataStore txDataStore = this.txModule.createTransactionStore(dataLoaderFactory, indexer, attributeTypes);
        final DataStoreAdmin dataStoreAdmin = this.adminModule.createDataStoreAdmin();
        return new DataModule(){

            public DataFactory getDataFactory() {
                return dataFactory;
            }

            public DataLoaderFactory getDataLoaderFactory() {
                return dataLoaderFactory;
            }

            public QueryEngine getQueryEngine() {
                return queryEngine;
            }

            public BranchDataStore getBranchDataStore() {
                return branchDataStore;
            }

            public KeyValueStore getKeyValueStore() {
                return keyValueStore;
            }

            public TxDataStore getTxDataStore() {
                return txDataStore;
            }

            public DataStoreAdmin getDataStoreAdmin() {
                return dataStoreAdmin;
            }
        };
    }
}

