/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal;

import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcMigrationOptions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.core.ds.DataStoreAdmin;
import org.eclipse.osee.orcs.core.ds.DataStoreInfo;
import org.eclipse.osee.orcs.core.ds.OrcsTypesDataStore;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.callable.FetchDatastoreInfoCallable;
import org.eclipse.osee.orcs.db.internal.callable.InitializeDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.callable.MigrateDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.util.DynamicSchemaResourceProvider;

public class AdminModule {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final IdentityManager identityService;
    private final SystemPreferences preferences;
    private final OrcsTypesDataStore typesDataStore;

    public AdminModule(Log logger, JdbcClient jdbcClient, IdentityManager identityService, SystemPreferences preferences, OrcsTypesDataStore typesDataStore) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.identityService = identityService;
        this.preferences = preferences;
        this.typesDataStore = typesDataStore;
    }

    public DataStoreAdmin createDataStoreAdmin() {
        return new DataStoreAdmin(){

            public Callable<DataStoreInfo> createDataStore(OrcsSession session, Map<String, String> parameters) {
                this.getOption(parameters, "schema.table.data.namespace", "");
                this.getOption(parameters, "schema.index.data.namespace", "");
                this.getOption(parameters, "schema.user.file.specified.schema.names", false);
                DynamicSchemaResourceProvider schemaProvider = new DynamicSchemaResourceProvider(AdminModule.this.logger);
                JdbcMigrationOptions options = new JdbcMigrationOptions(true, true);
                return new InitializeDatastoreCallable(session, AdminModule.this.logger, AdminModule.this.jdbcClient, AdminModule.this.identityService, AdminModule.this.preferences, schemaProvider, options);
            }

            public Callable<DataStoreInfo> migrateDataStore(OrcsSession session) {
                DynamicSchemaResourceProvider schemaProvider = new DynamicSchemaResourceProvider(AdminModule.this.logger);
                JdbcMigrationOptions options = new JdbcMigrationOptions(false, false);
                return new MigrateDatastoreCallable(session, AdminModule.this.logger, AdminModule.this.jdbcClient, AdminModule.this.preferences, schemaProvider, options);
            }

            public Callable<DataStoreInfo> getDataStoreInfo(OrcsSession session) {
                DynamicSchemaResourceProvider schemaProvider = new DynamicSchemaResourceProvider(AdminModule.this.logger);
                return new FetchDatastoreInfoCallable(AdminModule.this.logger, session, AdminModule.this.jdbcClient, schemaProvider, AdminModule.this.preferences);
            }

            private boolean getOption(Map<String, String> parameters, String key, boolean defaultValue) {
                boolean toReturn = defaultValue;
                String value = parameters.get(key);
                if (Strings.isValid((String)value)) {
                    toReturn = Boolean.parseBoolean(value);
                }
                return toReturn;
            }

            private String getOption(Map<String, String> parameters, String key, String defaultValue) {
                String toReturn = defaultValue;
                String value = parameters.get(key);
                if (Strings.isValid((String)value)) {
                    toReturn = value;
                }
                return toReturn;
            }

            public boolean isDataStoreInitialized() {
                boolean initialized = false;
                try {
                    IResource resource;
                    String systemUuid = AdminModule.this.preferences.getSystemUuid();
                    if (Strings.isValid((String)systemUuid) && (resource = (IResource)AdminModule.this.typesDataStore.getOrcsTypesLoader(null).call()) != null) {
                        initialized = true;
                    }
                }
                catch (Exception exception) {}
                return initialized;
            }
        };
    }
}

