/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.type;

import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.core.model.AbstractOseeIdType;
import org.eclipse.osee.framework.core.model.OseeField;
import org.eclipse.osee.framework.core.model.type.ArtifactType;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public final class RelationType
extends AbstractOseeIdType
implements RelationTypeToken {
    private static final String RELATION_SIDE_A_NAME_FIELD_KEY = "osee.relation.type.side.a.name.field";
    private static final String RELATION_SIDE_B_NAME_FIELD_KEY = "osee.relation.type.side.b.name.field";
    private static final String RELATION_SIDE_A_ART_TYPE_FIELD_KEY = "osee.relation.type.side.a.artifact.type.field";
    private static final String RELATION_SIDE_B_ART_TYPE_FIELD_KEY = "osee.relation.type.side.b.artifact.type.field";
    private static final String RELATION_DEFAULT_ORDER_TYPE_GUID_FIELD_KEY = "osee.relation.type.default.order.type.guid.field";
    private static final String RELATION_MULTIPLICITY_FIELD_KEY = "osee.relation.type.multiplicity.field";

    public RelationType(Long guid, String relationTypeName, String sideAName, String sideBName, IArtifactType artifactTypeSideA, IArtifactType artifactTypeSideB, RelationTypeMultiplicity multiplicity, RelationSorter defaultRelationSorter) {
        super(guid, relationTypeName);
        this.initializeFields();
        this.setFields(relationTypeName, sideAName, sideBName, artifactTypeSideA, artifactTypeSideB, multiplicity, defaultRelationSorter);
    }

    protected void initializeFields() {
        this.addField(RELATION_SIDE_A_NAME_FIELD_KEY, new OseeField());
        this.addField(RELATION_SIDE_B_NAME_FIELD_KEY, new OseeField());
        this.addField(RELATION_SIDE_A_ART_TYPE_FIELD_KEY, new OseeField());
        this.addField(RELATION_SIDE_B_ART_TYPE_FIELD_KEY, new OseeField());
        this.addField(RELATION_DEFAULT_ORDER_TYPE_GUID_FIELD_KEY, new OseeField());
        this.addField(RELATION_MULTIPLICITY_FIELD_KEY, new OseeField());
    }

    public void setFields(String relationTypeName, String sideAName, String sideBName, IArtifactType artifactTypeSideA, IArtifactType artifactTypeSideB, RelationTypeMultiplicity multiplicity, RelationSorter defaultRelationSorter) {
        this.setName(relationTypeName);
        this.setFieldLogException(RELATION_SIDE_A_NAME_FIELD_KEY, sideAName);
        this.setFieldLogException(RELATION_SIDE_B_NAME_FIELD_KEY, sideBName);
        this.setFieldLogException(RELATION_SIDE_A_ART_TYPE_FIELD_KEY, artifactTypeSideA);
        this.setFieldLogException(RELATION_SIDE_B_ART_TYPE_FIELD_KEY, artifactTypeSideB);
        this.setFieldLogException(RELATION_DEFAULT_ORDER_TYPE_GUID_FIELD_KEY, defaultRelationSorter);
        this.setFieldLogException(RELATION_MULTIPLICITY_FIELD_KEY, multiplicity);
    }

    public RelationTypeMultiplicity getMultiplicity() {
        return this.getFieldValueLogException(null, RELATION_MULTIPLICITY_FIELD_KEY);
    }

    public IArtifactType getArtifactTypeSideA() {
        return this.getFieldValueLogException(null, RELATION_SIDE_A_ART_TYPE_FIELD_KEY);
    }

    public IArtifactType getArtifactTypeSideB() {
        return this.getFieldValueLogException(null, RELATION_SIDE_B_ART_TYPE_FIELD_KEY);
    }

    public IArtifactType getArtifactType(RelationSide relationSide) {
        return relationSide == RelationSide.SIDE_A ? this.getArtifactTypeSideA() : this.getArtifactTypeSideB();
    }

    public String getSideName(RelationSide relationSide) {
        return relationSide == RelationSide.SIDE_A ? this.getSideAName() : this.getSideBName();
    }

    public boolean isArtifactTypeAllowed(RelationSide relationSide, ArtifactType artifactType) {
        IArtifactType allowedType = this.getArtifactType(relationSide);
        return artifactType.inheritsFrom(new ArtifactTypeId[]{allowedType});
    }

    public String getSideAName() {
        return this.getFieldValueLogException("", RELATION_SIDE_A_NAME_FIELD_KEY);
    }

    public String getSideBName() {
        return this.getFieldValueLogException("", RELATION_SIDE_B_NAME_FIELD_KEY);
    }

    public boolean isSideAName(String sideName) throws OseeArgumentException {
        if (!this.getSideAName().equals(sideName) && !this.getSideBName().equals(sideName)) {
            throw new OseeArgumentException("sideName does not match either of the available side names", new Object[0]);
        }
        return this.getSideAName().equals(sideName);
    }

    public String toString() {
        return String.format("[%s]<-[%s]->[%s]", this.getSideAName(), this.getName(), this.getSideBName());
    }

    public boolean isOrdered() {
        return !RelationSorter.UNORDERED.equals((Object)this.getDefaultOrderTypeGuid());
    }

    public RelationSorter getDefaultOrderTypeGuid() {
        return this.getFieldValueLogException(null, RELATION_DEFAULT_ORDER_TYPE_GUID_FIELD_KEY);
    }

    @Override
    public Long getGuid() {
        return this.getId();
    }
}

